/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerBulkItemFilter
extends ContainerSmartFilter {
    private static final int INV_START = 54;
    private static final int INV_END = 80;
    private static final int HOTBAR_START = 81;
    private static final int HOTBAR_END = 89;
    private static final int PLAYER_INV_X = 8;
    private static final int PLAYER_INV_Y = 151;
    private static final int PLAYER_HOTBAR_Y = 209;
    private final int currentSlot;
    private final BaseModuleHandler.BulkFilterHandler handler;

    public ContainerBulkItemFilter(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(windowId, invPlayer, MFLocator.fromBuffer(extraData));
    }

    public ContainerBulkItemFilter(int windowId, Inventory invPlayer, MFLocator loc) {
        super((MenuType)ModContainerTypes.CONTAINER_BULK_ITEM_FILTER.get(), windowId, invPlayer, loc);
        int i;
        this.handler = new BaseModuleHandler.BulkFilterHandler(this.filterStack, this.router);
        this.currentSlot = invPlayer.f_35977_ + 81;
        for (i = 0; i < this.handler.getSlots(); ++i) {
            this.m_38897_((Slot)new FilterSlot((IItemHandler)this.handler, i, 8 + 18 * (i % 9), 19 + 18 * (i / 9)));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)invPlayer, j + i * 9 + 9, 8 + j * 18, 151 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)invPlayer, i, 8 + i * 18, 209));
        }
    }

    public void clearSlots() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.handler.save();
        if (this.getRouter() != null && !this.getRouter().m_58904_().f_46443_) {
            this.getRouter().recompileNeeded(1);
        }
    }

    public int mergeInventory(IItemHandler srcInv, Filter.Flags flags, boolean clearFirst) {
        if (srcInv == null) {
            return 0;
        }
        SetofItemStack stacks = clearFirst ? new SetofItemStack(flags) : SetofItemStack.fromItemHandler((IItemHandler)this.handler, flags);
        int origSize = stacks.size();
        for (int i = 0; i < srcInv.getSlots() && stacks.size() < this.handler.getSlots(); ++i) {
            ItemStack stack = srcInv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        int slot = 0;
        for (ItemStack stack : stacks.sortedList()) {
            this.handler.setStackInSlot(slot++, stack);
        }
        while (slot < this.handler.getSlots()) {
            this.handler.setStackInSlot(slot++, ItemStack.f_41583_);
        }
        this.handler.save();
        if (this.getRouter() != null && !this.getRouter().m_58904_().f_46443_) {
            this.getRouter().recompileNeeded(1);
        }
        return stacks.size() - origSize;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot srcSlot = (Slot)this.f_38839_.get(index);
        if (srcSlot != null && srcSlot.m_6657_()) {
            ItemStack stackInSlot = srcSlot.m_7993_();
            ItemStack stack = stackInSlot.m_41777_();
            stack.m_41764_(1);
            if (index < this.handler.getSlots()) {
                srcSlot.m_5852_(ItemStack.f_41583_);
            } else if (index >= this.handler.getSlots()) {
                ItemStack stack0;
                int freeSlot;
                for (freeSlot = 0; freeSlot < this.handler.getSlots() && !(stack0 = this.handler.getStackInSlot(freeSlot)).m_41619_() && !ItemStack.m_41728_((ItemStack)stack0, (ItemStack)stack); ++freeSlot) {
                }
                if (freeSlot < this.handler.getSlots()) {
                    ((Slot)this.f_38839_.get(freeSlot)).m_5852_(stack);
                    srcSlot.m_5852_(stackInSlot);
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slot, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.PICKUP) {
            if (this.router == null && slot == this.currentSlot) {
                return;
            }
            if (slot < this.handler.getSlots() && slot >= 0) {
                Slot s = (Slot)this.f_38839_.get(slot);
                ItemStack stackOnCursor = this.m_142621_();
                if (!stackOnCursor.m_41619_()) {
                    ItemStack stack1 = stackOnCursor.m_41777_();
                    stack1.m_41764_(1);
                    s.m_5852_(stack1);
                } else {
                    s.m_5852_(ItemStack.f_41583_);
                }
                return;
            }
        }
        if (slot < this.handler.getSlots() && slot >= 0) {
            return;
        }
        super.m_150399_(slot, dragType, clickTypeIn, player);
    }
}

