/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.itemcollectors.ClientProxy;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class CollectorBlock
extends BaseBlock
implements EntityBlock {
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.f_61372_;
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)5.0, (double)6.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)10.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
    private static final BlockShape[] SHAPES = new BlockShape[6];
    private final BiFunction<BlockPos, BlockState, CollectorTile> tileSupplier;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;

    public CollectorBlock(String registryName, BiFunction<BlockPos, BlockState, CollectorTile> tileSupplier, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(registryName, false, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60999_().m_60913_(5.0f, 1200.0f));
        this.tileSupplier = tileSupplier;
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(DIRECTION, (Comparable)Direction.DOWN));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, final BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (worldIn.f_46443_ && !this.hasFilter.get().booleanValue()) {
            ClientProxy.openBasicCollectorScreen(pos);
        } else if (!worldIn.f_46443_ && this.hasFilter.get().booleanValue()) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return TextComponents.empty().get();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return new AdvancedCollectorContainer(id, player, pos);
                }
            }, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (BlockEntity)this.tileSupplier.apply(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType.getRegistryName().m_135827_().equals("itemcollectors") ? (world2, pos, state2, entity) -> ((CollectorTile)entity).tick() : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_(DIRECTION)).m_122411_()].getUnderlying();
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)TextComponents.translation((String)("itemcollectors." + (this.hasFilter.get() != false ? "advanced" : "basic") + "_collector.info"), (Object[])new Object[]{this.maxRange.get()}).color(ChatFormatting.AQUA).get());
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(DIRECTION, (Comparable)context.m_43719_().m_122424_());
    }

    static {
        CollectorBlock.SHAPES[Direction.DOWN.m_122411_()] = SHAPE;
        CollectorBlock.SHAPES[Direction.UP.m_122411_()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.NORTH.m_122411_()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.EAST.m_122411_()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.SOUTH.m_122411_()] = SHAPE.rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.WEST.m_122411_()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y);
    }
}

