/*
 * Decompiled with CFR 0.152.
 */
package ca.edtoaster.littlecontraptions.ponder.element;

import ca.edtoaster.littlecontraptions.ponder.element.AnimateVehicleInstructions;
import ca.edtoaster.littlecontraptions.ponder.element.VehicleElement;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.element.PonderElement;
import com.simibubi.create.foundation.ponder.instruction.FadeIntoSceneInstruction;
import com.simibubi.create.foundation.ponder.instruction.FadeOutOfSceneInstruction;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class VehicleInstructions {
    private SceneBuilder builder;

    public VehicleInstructions(SceneBuilder builder) {
        this.builder = builder;
    }

    public <T extends Entity> ElementLink<VehicleElement<T>> createVehicle(Vec3 location, float angle, VehicleElement.EntityConstructor<T> type) {
        VehicleElement cart = new VehicleElement(location.m_82492_(0.0, 0.5, 0.0), angle, type);
        ElementLink link = new ElementLink(((Object)cart).getClass());
        this.builder.addInstruction((PonderInstruction)new FadeInVehicleInstruction(10, Direction.DOWN, cart));
        this.builder.addInstruction(scene -> scene.linkElement((PonderElement)cart, link));
        return link;
    }

    public <T extends Entity> void rotateVehicle(ElementLink<VehicleElement<T>> link, float yRotation, int duration) {
        this.builder.addInstruction(AnimateVehicleInstructions.rotate(link, yRotation, duration));
    }

    public <T extends Entity> void moveVehicle(ElementLink<VehicleElement<T>> link, Vec3 offset, int duration) {
        this.builder.addInstruction(AnimateVehicleInstructions.move(link, offset, duration));
    }

    public <T extends Entity> void removeVehicle(ElementLink<VehicleElement<T>> elem) {
        this.builder.addInstruction((PonderInstruction)new FadeOutVehicleInstruction(10, Direction.DOWN, elem));
    }

    public static class FadeInVehicleInstruction
    extends FadeIntoSceneInstruction<VehicleElement> {
        public FadeInVehicleInstruction(int fadeInTicks, Direction fadeInFrom, VehicleElement element) {
            super(fadeInTicks, fadeInFrom, (AnimatedSceneElement)element);
        }

        protected Class<VehicleElement> getElementClass() {
            return VehicleElement.class;
        }
    }

    public static class FadeOutVehicleInstruction
    extends FadeOutOfSceneInstruction<VehicleElement> {
        public FadeOutVehicleInstruction(int fadeInTicks, Direction fadeInFrom, ElementLink element) {
            super(fadeInTicks, fadeInFrom, element);
        }

        protected Class<VehicleElement> getElementClass() {
            return VehicleElement.class;
        }
    }
}

