/*
 * Decompiled with CFR 0.152.
 */
package ca.edtoaster.littlecontraptions.block;

import ca.edtoaster.littlecontraptions.block.BargeAssemblerBlock;
import ca.edtoaster.littlecontraptions.entity.ContraptionBargeEntity;
import ca.edtoaster.littlecontraptions.setup.LCBlockEntityTypes;
import ca.edtoaster.littlecontraptions.setup.LCBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BargeAssemblerBlockEntity
extends SmartTileEntity {
    private static final int assemblyCooldown = 8;
    private int ticksSinceLastUpdate = 0;
    protected AssemblyException lastException;

    public BargeAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LCBlockEntityTypes.BARGE_ASSEMBLER.get(), pos, state);
    }

    private void serverTick() {
        this.tick();
        if (this.ticksSinceLastUpdate < 8) {
            ++this.ticksSinceLastUpdate;
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        List barges = this.f_58857_.m_142425_(EntityTypeTest.m_156916_(ContraptionBargeEntity.class), new AABB(this.m_58899_()).m_82406_((double)0.3f), e -> true);
        if (barges.size() > 0) {
            this.tryApplyActions((ContraptionBargeEntity)((Object)barges.get(0)));
        }
    }

    public void tryApplyActions(ContraptionBargeEntity barge) {
        CartAssemblerBlock.CartAssemblerAction action;
        if (barge == null || this.f_58857_ == null || !this.canUpdate()) {
            return;
        }
        this.setUpdated();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() != LCBlocks.BARGE_ASSEMBLER.get()) {
            return;
        }
        CartAssemblerBlock.CartAssemblerAction cartAssemblerAction = action = (Boolean)this.m_58900_().m_61143_((Property)BargeAssemblerBlock.POWERED) != false ? CartAssemblerBlock.CartAssemblerAction.ASSEMBLE : CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE;
        if (action.shouldAssemble()) {
            this.assemble(this.f_58857_, this.f_58858_, barge);
        }
        if (action.shouldDisassemble()) {
            this.disassemble(this.f_58857_, this.f_58858_, barge);
        }
    }

    protected void assemble(Level world, BlockPos pos, ContraptionBargeEntity barge) {
        if (!barge.m_20197_().isEmpty()) {
            return;
        }
        CartAssemblerTileEntity.CartMovementMode mode = CartAssemblerTileEntity.CartMovementMode.ROTATE;
        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos)) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            e.printStackTrace();
            return;
        }
        Direction initialOrientation = BargeAssemblerBlock.getHorizontalDirection(this.m_58900_());
        contraption.removeBlocksFromWorld(world, BlockPos.f_121853_);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        OrientedContraptionEntity entity = OrientedContraptionEntity.create((Level)world, (Contraption)contraption, (Direction)initialOrientation);
        entity.m_146884_(barge.getRiderPosition());
        world.m_7967_((Entity)entity);
        entity.m_20329_((Entity)barge);
    }

    protected void disassemble(Level world, BlockPos pos, ContraptionBargeEntity barge) {
        if (barge.m_20197_().isEmpty()) {
            return;
        }
        Entity entity = (Entity)barge.m_20197_().get(0);
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        contraption.yaw = BargeAssemblerBlock.getHorizontalDirection(this.m_58900_()).m_122435_();
        barge.m_20153_();
    }

    public void setUpdated() {
        this.ticksSinceLastUpdate = 0;
    }

    private boolean canUpdate() {
        return this.ticksSinceLastUpdate >= 8;
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, BargeAssemblerBlockEntity e) {
        e.serverTick();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lastException = AssemblyException.read((CompoundTag)compound);
        super.read(compound, clientPacket);
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new BargeAssemblerValueBoxTransform();
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    private class BargeAssemblerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public BargeAssemblerValueBoxTransform() {
            super((state, d) -> {
                if (d.m_122434_().m_122478_()) {
                    return false;
                }
                if (!state.m_61138_((Property)BargeAssemblerBlock.FACING)) {
                    return false;
                }
                return ((Direction)state.m_61143_((Property)BargeAssemblerBlock.FACING)).m_122434_() != d.m_122434_();
            });
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)18.0);
        }
    }
}

