/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curiouselytra.client.CuriousElytraClientMod;
import top.theillusivec4.curiouselytra.common.CurioElytra;
import top.theillusivec4.curiouselytra.common.IElytraProvider;
import top.theillusivec4.curiouselytra.common.VanillaElytraProvider;
import top.theillusivec4.curiouselytra.common.integration.SilentGearElytraProvider;

@Mod(value="curiouselytra")
public class CuriousElytraMod {
    public static final String MOD_ID = "curiouselytra";
    private static final Map<String, Supplier<Supplier<IElytraProvider>>> PROVIDERS = new HashMap<String, Supplier<Supplier<IElytraProvider>>>();
    private static final List<IElytraProvider> ACTIVE_PROVIDERS = new ArrayList<IElytraProvider>();
    public static boolean isQuarkLoaded = false;

    public CuriousElytraMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::setup);
        ModList modList = ModList.get();
        for (Map.Entry<String, Supplier<Supplier<IElytraProvider>>> entry : PROVIDERS.entrySet()) {
            if (!modList.isLoaded(entry.getKey())) continue;
            ACTIVE_PROVIDERS.add(entry.getValue().get().get());
        }
        ACTIVE_PROVIDERS.add(new VanillaElytraProvider());
        isQuarkLoaded = modList.isLoaded("quark");
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        CuriousElytraClientMod.setup();
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void playerTick(TickEvent.PlayerTickEvent evt) {
        Player player = evt.player;
        AttributeInstance attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
        if (attributeInstance != null) {
            attributeInstance.m_22130_(CurioElytra.ELYTRA_CURIO_MODIFIER);
            if (!attributeInstance.m_22109_(CurioElytra.ELYTRA_CURIO_MODIFIER) && CuriousElytraMod.getElytra((LivingEntity)player, true).isPresent()) {
                attributeInstance.m_22118_(CurioElytra.ELYTRA_CURIO_MODIFIER);
            }
        }
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        boolean attachable = false;
        for (IElytraProvider module : ACTIVE_PROVIDERS) {
            if (!module.attachCapability(stack)) continue;
            attachable = true;
            break;
        }
        if (attachable) {
            final LazyOptional elytraCurio = LazyOptional.of(() -> new CurioElytra(stack));
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, elytraCurio);
                }
            });
            evt.addListener(() -> ((LazyOptional)elytraCurio).invalidate());
        }
    }

    public static Optional<Pair<IElytraProvider, ItemStack>> getElytra(LivingEntity livingEntity, boolean shouldFly) {
        AtomicReference atomicProvider = new AtomicReference();
        AtomicReference<ItemStack> atomicStack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(curios -> {
            for (Map.Entry entry : curios.getCurios().entrySet()) {
                IDynamicStackHandler stacks = ((ICurioStacksHandler)entry.getValue()).getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    for (IElytraProvider provider : ACTIVE_PROVIDERS) {
                        if (!provider.matches(stack) || shouldFly && !provider.canFly(stack, livingEntity)) continue;
                        atomicProvider.set(provider);
                        atomicStack.set(stack);
                    }
                }
            }
        });
        IElytraProvider resultProvider = (IElytraProvider)atomicProvider.get();
        ItemStack resultStack = atomicStack.get();
        return resultProvider != null ? Optional.of(new Pair((Object)resultProvider, (Object)resultStack)) : Optional.empty();
    }

    static {
        PROVIDERS.put("silentgear", () -> SilentGearElytraProvider::new);
    }
}

