/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.mixin;

import fuzs.easyshulkerboxes.world.item.ContainerItemHelper;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class}, priority=900)
public abstract class ItemMixin {
    @Inject(method={"overrideStackedOnOther"}, at={@At(value="HEAD")}, cancellable=true)
    public void overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) {
            boolean success = ContainerItemHelper.overrideStackedOnOther(stack, BlockEntityType.f_58939_, 3, slot, clickAction, player, s -> s.m_41720_().m_142095_(), SoundEvents.f_184215_, SoundEvents.f_184216_);
            callbackInfo.setReturnValue((Object)success);
        }
    }

    @Inject(method={"overrideOtherStackedOnMe"}, at={@At(value="HEAD")}, cancellable=true)
    public void overrideOtherStackedOnMe(ItemStack stack, ItemStack stackOnMe, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) {
            boolean success = ContainerItemHelper.overrideOtherStackedOnMe(stack, BlockEntityType.f_58939_, 3, stackOnMe, slot, clickAction, player, slotAccess, s -> s.m_41720_().m_142095_(), SoundEvents.f_184215_, SoundEvents.f_184216_);
            callbackInfo.setReturnValue((Object)success);
        }
    }

    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTooltipImage(ItemStack stack, CallbackInfoReturnable<Optional<TooltipComponent>> callbackInfo) {
        if (Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) {
            DyeColor color = ShulkerBoxBlock.m_56252_((Item)stack.m_41720_());
            Optional<TooltipComponent> component = ContainerItemHelper.getTooltipImage(stack, BlockEntityType.f_58939_, 3, color);
            callbackInfo.setReturnValue(component);
        }
    }
}

