/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.client.gui.screens.inventory.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.config.ClientConfig;
import fuzs.easyshulkerboxes.world.inventory.tooltip.ContainerItemTooltip;
import fuzs.puzzleslib.proxy.IProxy;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ClientContainerItemTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");
    private static final Component HOLD_SHIFT_COMPONENT = new TranslatableComponent("item.container.tooltip.info", new Object[]{new TranslatableComponent("item.container.tooltip.shift").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY);
    private final NonNullList<ItemStack> items;
    private final int containerRows;
    @Nullable
    private final DyeColor backgroundColor;

    public ClientContainerItemTooltip(ContainerItemTooltip tooltip) {
        this.items = tooltip.items();
        this.containerRows = tooltip.containerRows();
        this.backgroundColor = tooltip.backgroundColor();
    }

    public void m_142440_(Font p_169943_, int p_169944_, int p_169945_, Matrix4f p_169946_, MultiBufferSource.BufferSource p_169947_) {
        if (this.hideInventoryContents()) {
            p_169943_.m_92841_(HOLD_SHIFT_COMPONENT, (float)p_169944_, (float)p_169945_, -1, true, p_169946_, (MultiBufferSource)p_169947_, false, 0, 0xF000F0);
        }
    }

    public int m_142103_() {
        if (this.hideInventoryContents()) {
            return 10;
        }
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int m_142069_(Font font) {
        if (this.hideInventoryContents()) {
            return font.m_92852_((FormattedText)HOLD_SHIFT_COMPONENT);
        }
        return this.gridSizeX() * 18 + 2;
    }

    public void m_183452_(Font p_194042_, int p_194043_, int p_194044_, PoseStack p_194045_, ItemRenderer p_194046_, int p_194047_) {
        if (this.hideInventoryContents()) {
            return;
        }
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        int k = 0;
        int lastFilledSlot = this.getLastFilledSlot();
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = p_194043_ + i1 * 18 + 1;
                int k1 = p_194044_ + l * 20 + 1;
                this.renderSlot(j1, k1, k, p_194042_, p_194045_, p_194046_, p_194047_, k == lastFilledSlot);
                ++k;
            }
        }
        this.drawBorder(p_194043_, p_194044_, i, j, p_194045_, p_194047_);
    }

    private boolean hideInventoryContents() {
        return ((ClientConfig)EasyShulkerBoxes.CONFIG.client()).contentsRequireShift && !IProxy.INSTANCE.hasShiftDown();
    }

    private int getLastFilledSlot() {
        if (((ClientConfig)EasyShulkerBoxes.CONFIG.client()).slotOverlay) {
            for (int i = this.items.size() - 1; i >= 0; --i) {
                if (((ItemStack)this.items.get(i)).m_41619_()) continue;
                return i;
            }
        }
        return -1;
    }

    private void renderSlot(int p_194027_, int p_194028_, int p_194029_, Font p_194031_, PoseStack p_194032_, ItemRenderer p_194033_, int p_194034_, boolean lastFilledSlot) {
        if (p_194029_ >= this.items.size()) {
            this.blit(p_194032_, p_194027_, p_194028_, p_194034_, Texture.SLOT);
        } else {
            ItemStack itemstack = (ItemStack)this.items.get(p_194029_);
            this.blit(p_194032_, p_194027_, p_194028_, p_194034_, Texture.SLOT);
            p_194033_.m_174253_(itemstack, p_194027_ + 1, p_194028_ + 1, p_194029_);
            p_194033_.m_115169_(p_194031_, itemstack, p_194027_ + 1, p_194028_ + 1);
            if (lastFilledSlot) {
                AbstractContainerScreen.m_169606_((PoseStack)p_194032_, (int)(p_194027_ + 1), (int)(p_194028_ + 1), (int)p_194034_);
            }
        }
    }

    private void drawBorder(int p_194020_, int p_194021_, int p_194022_, int p_194023_, PoseStack p_194024_, int p_194025_) {
        this.blit(p_194024_, p_194020_, p_194021_, p_194025_, Texture.BORDER_CORNER_TOP);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_, p_194025_, Texture.BORDER_CORNER_TOP);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, p_194020_ + 1 + i * 18, p_194021_, p_194025_, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(p_194024_, p_194020_ + 1 + i * 18, p_194021_ + p_194023_ * 20, p_194025_, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, p_194020_, p_194021_ + j * 20 + 1, p_194025_, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_ + j * 20 + 1, p_194025_, Texture.BORDER_VERTICAL);
        }
        this.blit(p_194024_, p_194020_, p_194021_ + p_194023_ * 20, p_194025_, Texture.BORDER_CORNER_BOTTOM);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_ + p_194023_ * 20, p_194025_, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(PoseStack p_194036_, int p_194037_, int p_194038_, int p_194039_, Texture p_194040_) {
        float[] color = this.getBackgroundColor();
        RenderSystem.m_157429_((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93143_((PoseStack)p_194036_, (int)p_194037_, (int)p_194038_, (int)p_194039_, (float)p_194040_.x, (float)p_194040_.y, (int)p_194040_.w, (int)p_194040_.h, (int)128, (int)128);
    }

    private float[] getBackgroundColor() {
        if (!((ClientConfig)EasyShulkerBoxes.CONFIG.client()).colorfulTooltips || this.backgroundColor == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        if (this.backgroundColor == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        return this.backgroundColor.m_41068_();
    }

    private int gridSizeX() {
        return 9;
    }

    private int gridSizeY() {
        return this.containerRows;
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

