/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderBioGenerator
extends MekanismTileEntityRenderer<TileEntityBioGenerator> {
    private static final Map<Direction, Int2ObjectMap<MekanismRenderer.Model3D>> fuelModels = new EnumMap<Direction, Int2ObjectMap<MekanismRenderer.Model3D>>(Direction.class);
    private static final int stages = 40;

    public static void resetCachedModels() {
        fuelModels.clear();
    }

    public RenderBioGenerator(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityBioGenerator tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        if (!tile.bioFuelTank.isEmpty()) {
            matrix.m_85836_();
            FluidStack fluid = tile.bioFuelTank.getFluid();
            float fluidScale = (float)fluid.getAmount() / (float)tile.bioFuelTank.getCapacity();
            int modelNumber = ModelRenderer.getStage((FluidStack)fluid, (int)40, (double)fluidScale);
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getModel(tile.getDirection(), modelNumber), (PoseStack)matrix, (VertexConsumer)renderer.m_6299_(Sheets.m_110792_()), (int)MekanismRenderer.getColorARGB((FluidStack)fluid, (float)fluidScale), (int)0xF000F0, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT);
            matrix.m_85849_();
        }
    }

    protected String getProfilerSection() {
        return "bioGenerator";
    }

    private MekanismRenderer.Model3D getModel(Direction side, int stage) {
        if (fuelModels.containsKey(side) && fuelModels.get(side).containsKey(stage)) {
            return (MekanismRenderer.Model3D)fuelModels.get(side).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture((FluidStack)GeneratorsFluids.BIOETHANOL.getFluidStack(1), (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL));
        switch (side) {
            case NORTH: {
                model.minZ = 0.499f;
                model.maxZ = 0.875f;
                model.minX = 0.188f;
                model.maxX = 0.821f;
                break;
            }
            case SOUTH: {
                model.minZ = 0.125f;
                model.maxZ = 0.499f;
                model.minX = 0.188f;
                model.maxX = 0.821f;
                break;
            }
            case WEST: {
                model.minX = 0.499f;
                model.maxX = 0.875f;
                model.minZ = 0.187f;
                model.maxZ = 0.821f;
                break;
            }
            case EAST: {
                model.minX = 0.125f;
                model.maxX = 0.499f;
                model.minZ = 0.186f;
                model.maxZ = 0.821f;
            }
        }
        model.minY = 0.4385f;
        model.maxY = 0.4385f + 0.4375f * ((float)stage / 40.0f);
        fuelModels.computeIfAbsent(side, s -> new Int2ObjectOpenHashMap()).putIfAbsent(stage, (Object)model);
        return model;
    }
}

