/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tags.TagUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.jei.recipe.FissionJEIRecipe;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FissionReactorRecipeCategory
extends BaseRecipeCategory<FissionJEIRecipe> {
    private static final ResourceLocation iconRL = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"radioactive.png");
    private final GuiGauge<?> coolantTank;
    private final GuiGauge<?> fuelTank;
    private final GuiGauge<?> heatedCoolantTank;
    private final GuiGauge<?> wasteTank;

    public FissionReactorRecipeCategory(IGuiHelper helper, MekanismJEIRecipeType<FissionJEIRecipe> recipeType) {
        super(helper, recipeType, (Component)GeneratorsLang.FISSION_REACTOR.translate(new Object[0]), FissionReactorRecipeCategory.createIcon((IGuiHelper)helper, (ResourceLocation)iconRL), 6, 13, 182, 60);
        this.addElement((GuiTexturedElement)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> List.of(MekanismLang.STATUS.translate(new Object[]{EnumColor.BRIGHT_GREEN, BooleanStateDisplay.ActiveDisabled.of((boolean)true)}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{1.0}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{0}), MekanismLang.TEMPERATURE.translate(new Object[]{EnumColor.BRIGHT_GREEN, MekanismUtils.getTemperatureDisplay((double)300.0, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{EnumColor.BRIGHT_GREEN, TextUtils.getPercent((double)0.0)}))).spacing(2));
        this.coolantTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiFluidGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)6, (int)13).setLabel((Component)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.fuelTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)25, (int)13).setLabel((Component)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.heatedCoolantTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)152, (int)13).setLabel((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.wasteTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)171, (int)13).setLabel((Component)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
    }

    private List<FluidStack> getWaterInput(FissionJEIRecipe recipe) {
        int amount = MathUtils.clampToInt((long)recipe.outputCoolant().getAmount());
        return TagUtils.tag((IForgeRegistry)ForgeRegistries.FLUIDS, (TagKey)FluidTags.f_13131_).stream().map(fluid -> new FluidStack(fluid, amount)).toList();
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, FissionJEIRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        if (recipe.inputCoolant() == null) {
            this.initFluid(builder, RecipeIngredientRole.INPUT, this.coolantTank, this.getWaterInput(recipe));
        } else {
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.coolantTank, recipe.inputCoolant().getRepresentations());
        }
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.fuelTank, recipe.fuel().getRepresentations());
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, (GuiElement)this.heatedCoolantTank, Collections.singletonList(recipe.outputCoolant()));
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, (GuiElement)this.wasteTank, Collections.singletonList(recipe.waste()));
    }

    public static List<FissionJEIRecipe> getFissionRecipes() {
        ArrayList<FissionJEIRecipe> recipes = new ArrayList<FissionJEIRecipe>();
        double energyPerFuel = ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get()).doubleValue();
        long coolantAmount = Math.round(energyPerFuel * HeatUtils.getSteamEnergyEfficiency() / HeatUtils.getWaterThermalEnthalpy());
        recipes.add(new FissionJEIRecipe(null, (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((IChemicalProvider)MekanismGases.FISSILE_FUEL, 1L), MekanismGases.STEAM.getStack(coolantAmount), MekanismGases.NUCLEAR_WASTE.getStack(1L)));
        for (Gas gas : MekanismAPI.gasRegistry()) {
            GasAttributes.CooledCoolant cooledCoolant = (GasAttributes.CooledCoolant)gas.get(GasAttributes.CooledCoolant.class);
            if (cooledCoolant == null) continue;
            Gas heatedCoolant = cooledCoolant.getHeatedGas();
            coolantAmount = Math.round(energyPerFuel / cooledCoolant.getThermalEnthalpy());
            recipes.add(new FissionJEIRecipe((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((IChemicalProvider)gas, coolantAmount), (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((IChemicalProvider)MekanismGases.FISSILE_FUEL, 1L), heatedCoolant.getStack(coolantAmount), MekanismGases.NUCLEAR_WASTE.getStack(1L)));
        }
        return recipes;
    }
}

