/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;

public class FillFluidContainerTransfer
implements IFluidContainerTransfer {
    public static final ResourceLocation ID = Mantle.getResource("fill_item");
    private final Ingredient input;
    private final ItemOutput filled;
    private final FluidIngredient fluid;
    public static final JsonDeserializer<FillFluidContainerTransfer> DESERIALIZER = new Deserializer<FillFluidContainerTransfer>(FillFluidContainerTransfer::new);

    @Override
    public void addRepresentativeItems(Consumer<Item> consumer) {
        for (ItemStack stack : this.input.m_43908_()) {
            consumer.accept(stack.m_41720_());
        }
    }

    @Override
    public boolean matches(ItemStack stack, FluidStack fluid) {
        return this.input.test(stack) && this.fluid.test(fluid);
    }

    protected ItemStack getFilled(FluidStack drained) {
        return this.filled.get().m_41777_();
    }

    @Override
    @Nullable
    public IFluidContainerTransfer.TransferResult transfer(ItemStack stack, FluidStack fluid, IFluidHandler handler) {
        int amount = this.fluid.getAmount(fluid.getFluid());
        FluidStack toDrain = new FluidStack(fluid, amount);
        FluidStack simulated = handler.drain(toDrain.copy(), IFluidHandler.FluidAction.SIMULATE);
        if (simulated.getAmount() == amount) {
            FluidStack actual = handler.drain(toDrain.copy(), IFluidHandler.FluidAction.EXECUTE);
            if (actual.getAmount() != amount) {
                Mantle.logger.error("Wrong amount drained from {}, expected {}, filled {}", (Object)stack.m_41720_().getRegistryName(), (Object)fluid.getAmount(), (Object)actual.getAmount());
            }
            return new IFluidContainerTransfer.TransferResult(this.getFilled(toDrain), toDrain, true);
        }
        return null;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("input", this.input.m_43942_());
        json.add("filled", this.filled.serialize());
        json.add("fluid", this.fluid.serialize());
        return json;
    }

    public FillFluidContainerTransfer(Ingredient input, ItemOutput filled, FluidIngredient fluid) {
        this.input = input;
        this.filled = filled;
        this.fluid = fluid;
    }

    public record Deserializer<T extends FillFluidContainerTransfer>(TriFunction<Ingredient, ItemOutput, FluidIngredient, T> factory) implements JsonDeserializer<T>
    {
        public T deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            Ingredient input = Ingredient.m_43917_((JsonElement)JsonHelper.getElement(json, "input"));
            ItemOutput filled = ItemOutput.fromJson(JsonHelper.getElement(json, "filled"));
            FluidIngredient fluid = FluidIngredient.deserialize(json, "fluid");
            return (T)((FillFluidContainerTransfer)this.factory.apply((Object)input, (Object)filled, (Object)fluid));
        }
    }
}

