/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.util.JsonHelper;

public class GenericRegisteredSerializer<T extends IJsonSerializable>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final Map<ResourceLocation, JsonDeserializer<? extends T>> deserializers = new HashMap<ResourceLocation, JsonDeserializer<? extends T>>();

    public void registerDeserializer(ResourceLocation name, JsonDeserializer<? extends T> jsonDeserializer) {
        this.deserializers.put(name, jsonDeserializer);
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"transformer");
        ResourceLocation type = JsonHelper.getResourceLocation(object, "type");
        JsonDeserializer<? extends T> deserializer = this.deserializers.get(type);
        if (deserializer == null) {
            throw new JsonSyntaxException("Unknown serializer " + type);
        }
        return (T)((IJsonSerializable)deserializer.deserialize(json, typeOfT, context));
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject serialized = src.serialize(context);
        if (!serialized.has("type")) {
            throw new IllegalArgumentException("Invalid serialized sprite transformer, missing type");
        }
        String typeStr = GsonHelper.m_13906_((JsonObject)serialized, (String)"type");
        ResourceLocation typeRL = ResourceLocation.m_135820_((String)typeStr);
        if (typeRL == null) {
            throw new IllegalArgumentException("Invalid sprite transformer type '" + typeStr + "'");
        }
        if (!this.deserializers.containsKey(typeRL)) {
            throw new IllegalArgumentException("Unregistered sprite transformer " + typeStr);
        }
        return serialized;
    }

    public static interface IJsonSerializable {
        public JsonObject serialize(JsonSerializationContext var1);
    }
}

