/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class ImageElement
extends SizedBookElement {
    public ImageData image;
    public int colorMultiplier;
    private ItemElement itemElement;

    public ImageElement(ImageData image) {
        this(image, 0xFFFFFF);
    }

    public ImageElement(ImageData image, int colorMultiplier) {
        this(image.x, image.y, image.width, image.height, image, colorMultiplier);
    }

    public ImageElement(int x, int y, int width, int height, ImageData image) {
        this(x, y, width, height, image, image.colorMultiplier);
    }

    public ImageElement(int x, int y, int width, int height, ImageData image, int colorMultiplier) {
        super(x, y, width, height);
        this.image = image;
        if (image.x != -1) {
            x = image.x;
        }
        if (image.y != -1) {
            y = image.y;
        }
        if (image.width != -1) {
            width = image.width;
        }
        if (image.height != -1) {
            height = image.height;
        }
        if (image.colorMultiplier != 0xFFFFFF) {
            colorMultiplier = image.colorMultiplier;
        }
        this.x = x == -1 ? 0 : x;
        this.y = y == -1 ? 0 : y;
        this.width = width;
        this.height = height;
        this.colorMultiplier = colorMultiplier;
        if (image.item != null) {
            this.itemElement = new ItemElement(0, 0, 1.0f, (Collection<ItemStack>)image.item.getItems());
        }
    }

    @Override
    public void draw(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        float r = (float)(this.colorMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.colorMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.colorMultiplier & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        if (this.image.item == null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)Objects.requireNonNullElse(this.image.location, TextureManager.f_118466_));
            ImageElement.blitRaw(matrixStack, this.x, this.y, this.width, this.height, this.image.u, this.image.u + this.image.uw, this.image.v, this.image.v + this.image.vh, this.image.texWidth, this.image.texHeight);
        } else {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)this.x, (double)this.y, 0.0);
            matrixStack.m_85841_((float)this.width / 16.0f, (float)this.height / 16.0f, 1.0f);
            this.itemElement.draw(matrixStack, mouseX, mouseY, partialTicks, fontRenderer);
            matrixStack.m_85849_();
        }
    }

    public static void blitRaw(PoseStack matrixStack, int x, int y, int w, int h, int minU, int maxU, int minV, int maxV, float tw, float th) {
        ImageElement.m_93112_((Matrix4f)matrixStack.m_85850_().m_85861_(), (int)x, (int)(x + w), (int)y, (int)(y + h), (int)0, (float)((float)minU / tw), (float)((float)maxU / tw), (float)((float)minV / th), (float)((float)maxV / th));
    }
}

