/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.screen.book.Textures;

public class ArrowButton
extends Button {
    public static final int WIDTH = 18;
    public static final int HEIGHT = 10;
    @Nullable
    private final BookData bookData;
    public ArrowType arrowType;
    public int color;
    public int hoverColor;

    public ArrowButton(@Nullable BookData bookData, int x, int y, ArrowType arrowType, int color, int hoverColor, Button.OnPress iPressable) {
        super(x, y, arrowType.w, arrowType.h, TextComponent.f_131282_, iPressable);
        this.arrowType = arrowType;
        this.color = color;
        this.hoverColor = hoverColor;
        this.bookData = bookData;
    }

    public ArrowButton(int x, int y, ArrowType arrowType, int color, int hoverColor, Button.OnPress iPressable) {
        this(null, x, y, arrowType, color, hoverColor, iPressable);
    }

    public void renderButton(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks, @Nullable BookData bookData) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (bookData != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)bookData.appearance.getBookTexture());
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.TEX_BOOK);
        }
        this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
        int color = this.f_93622_ ? this.hoverColor : this.color;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        ArrowButton.m_93160_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)this.f_93618_, (int)this.f_93619_, (float)this.arrowType.x, (float)this.arrowType.y, (int)this.f_93618_, (int)this.f_93619_, (int)512, (int)512);
        this.m_7906_(matrixStack, minecraft, mouseX, mouseY);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(matrixStack, mouseX, mouseY, partialTicks, this.bookData);
    }

    public static enum ArrowType {
        NEXT(412, 0),
        PREV(412, 10),
        RIGHT(412, 20),
        LEFT(412, 30),
        BACK_UP(412, 40, 18, 18),
        UP(412, 58, 10, 18),
        DOWN(422, 58, 10, 18),
        REFRESH(412, 76, 18, 18);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private ArrowType(int x, int y) {
            this(x, y, 18, 10);
        }

        private ArrowType(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

