/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world;

import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.world.WorldEvent;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class BiomeEvent {
    @SubscribeEvent
    public static void biomeLoad(BiomeLoadingEvent e) {
        if (e.getCategory() == Biome.BiomeCategory.NETHER || e.getCategory() == Biome.BiomeCategory.THEEND) {
            return;
        }
        BiomeEvent.addMobSpawns(e);
        if ((e.getCategory().equals((Object)Biome.BiomeCategory.TAIGA) || e.getName().equals((Object)new ResourceLocation("ars_nouveau", "archwood_forest"))) && ((Boolean)Config.SPAWN_BERRIES.get()).booleanValue()) {
            e.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldEvent.BERRY_BUSH_PATCH_CONFIG).m_47831_();
        }
        if ((Integer)Config.TREE_SPAWN_RATE.get() > 0) {
            e.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldEvent.PLACED_MIXED);
        }
    }

    public static void addMobSpawns(BiomeLoadingEvent e) {
        List<Biome.BiomeCategory> categories = Arrays.asList(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.JUNGLE, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.MOUNTAIN);
        if (categories.contains(e.getCategory())) {
            if ((Integer)Config.CARBUNCLE_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.STARBUNCLE_TYPE, ((Integer)Config.CARBUNCLE_WEIGHT.get()).intValue(), 1, 1));
            }
            if ((Integer)Config.SYLPH_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.WHIRLISPRIG_TYPE, ((Integer)Config.SYLPH_WEIGHT.get()).intValue(), 1, 1));
            }
        }
        if ((Integer)Config.DRYGMY_WEIGHT.get() > 0) {
            e.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.ENTITY_DRYGMY, ((Integer)Config.DRYGMY_WEIGHT.get()).intValue(), 1, 1));
        }
        if (!e.getCategory().equals((Object)Biome.BiomeCategory.MUSHROOM) && !e.getCategory().equals((Object)Biome.BiomeCategory.NONE)) {
            if (e.getClimate().f_47681_ <= 0.35f && (Integer)Config.WGUARDIAN_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.WILDEN_GUARDIAN, ((Integer)Config.WGUARDIAN_WEIGHT.get()).intValue(), 1, 1));
            }
            if ((Integer)Config.WSTALKER_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.WILDEN_STALKER, ((Integer)Config.WSTALKER_WEIGHT.get()).intValue(), 3, 3));
            }
            if ((Integer)Config.WHUNTER_WEIGHT.get() > 0) {
                e.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.WILDEN_HUNTER, ((Integer)Config.WHUNTER_WEIGHT.get()).intValue(), 1, 1));
            }
        }
    }
}

