/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IInteractResponder;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.items.CapabilityItemHandler;

public class EffectInteract
extends AbstractEffect {
    public static EffectInteract INSTANCE = new EffectInteract();

    private EffectInteract() {
        super("interact", "Interact");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        Entity e = rayTraceResult.m_82443_();
        if (e instanceof Animal) {
            if (shooter instanceof Player) {
                ((Animal)e).m_6071_((Player)shooter, InteractionHand.MAIN_HAND);
            } else if (shooter instanceof IInteractResponder) {
                ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
                fakePlayer.f_36093_.m_6211_();
                fakePlayer.m_6034_(e.m_20185_(), e.m_20186_(), e.m_20189_());
                ItemStack stack = ((IInteractResponder)shooter).getHeldItem().m_41777_();
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
                e.m_6096_((Player)fakePlayer, InteractionHand.MAIN_HAND);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (e instanceof IForgeShearable && fakePlayer.m_21205_().m_41720_() instanceof ShearsItem && ((IForgeShearable)e).isShearable(fakePlayer.m_21205_(), world, e.m_142538_())) {
                    items.addAll(((IForgeShearable)e).onSheared((Player)fakePlayer, fakePlayer.m_21205_(), world, e.m_142538_(), EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)fakePlayer.m_21205_())));
                }
                items.addAll((Collection<ItemStack>)fakePlayer.f_36093_.f_35974_);
                items.addAll((Collection<ItemStack>)fakePlayer.f_36093_.f_35975_);
                items.addAll((Collection<ItemStack>)fakePlayer.f_36093_.f_35976_);
                this.returnItems((HitResult)rayTraceResult, world, shooter, items);
            }
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos blockPos = rayTraceResult.m_82425_();
        BlockState blockState = world.m_8055_(blockPos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, blockPos)) {
            return;
        }
        if (world.m_7702_(blockPos) != null && world.m_7702_(blockPos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return;
        }
        if (this.isRealPlayer((Entity)shooter)) {
            blockState.m_60664_(world, (Player)shooter, InteractionHand.MAIN_HAND, rayTraceResult);
        } else {
            ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)world);
            ItemStack stack = shooter instanceof IInteractResponder ? ((IInteractResponder)shooter).getHeldItem().m_41777_() : ItemStack.f_41583_;
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            blockState.m_60664_(world, (Player)player, InteractionHand.MAIN_HAND, rayTraceResult);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (player.m_21205_().m_41720_() instanceof ShearsItem) {
                items.addAll((Collection<ItemStack>)player.f_36093_.f_35974_);
                items.addAll((Collection<ItemStack>)player.f_36093_.f_35975_);
                items.addAll((Collection<ItemStack>)player.f_36093_.f_35976_);
                this.returnItems((HitResult)rayTraceResult, world, shooter, items);
            }
        }
    }

    public void returnItems(HitResult rayTraceResult, Level world, LivingEntity shooter, List<ItemStack> items) {
        for (ItemStack i : items) {
            if (shooter instanceof IPickupResponder) {
                ItemStack leftOver = ((IPickupResponder)shooter).onPickup(i);
                if (leftOver.m_41619_()) continue;
                world.m_7967_((Entity)new ItemEntity(world, rayTraceResult.m_82450_().f_82479_, rayTraceResult.m_82450_().f_82480_, rayTraceResult.m_82450_().f_82481_, leftOver));
                continue;
            }
            world.m_7967_((Entity)new ItemEntity(world, rayTraceResult.m_82450_().f_82479_, rayTraceResult.m_82450_().f_82480_, rayTraceResult.m_82450_().f_82481_, i));
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return this.nonAirAnythingSuccess(rayTraceResult, world);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Interacts with blocks or entities as it were a player. Useful for reaching levers, chests, or animals.";
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

