/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;

public class EffectExchange
extends AbstractEffect {
    public static EffectExchange INSTANCE = new EffectExchange();

    private EffectExchange() {
        super("exchange", "Exchange");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        Entity entity = rayTraceResult.m_82443_();
        if (shooter != null) {
            Vec3 origLoc = shooter.f_19825_;
            shooter.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            entity.m_6021_(origLoc.m_7096_(), origLoc.m_7098_(), origLoc.m_7094_());
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult result, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, result.m_82425_(), result, spellStats.getAoeMultiplier(), spellStats.getBuffCount(AugmentPierce.INSTANCE));
        BlockState origState = world.m_8055_(result.m_82425_());
        Player playerEntity = this.getPlayer(shooter, (ServerLevel)world);
        NonNullList list = playerEntity.f_36093_.f_35974_;
        List<Object> handlers = new ArrayList();
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        if (spellContext.castingTile instanceof IPlaceBlockResponder && spellContext.castingTile instanceof IPickupResponder) {
            handlers = ((IPlaceBlockResponder)spellContext.castingTile).getInventory();
        }
        if (shooter instanceof IPlaceBlockResponder && shooter instanceof IPickupResponder) {
            handlers = ((IPlaceBlockResponder)shooter).getInventory();
        }
        Block firstBlock = null;
        block0: for (BlockPos pos1 : posList) {
            BlockState state = world.m_8055_(pos1);
            if (!this.canBlockBeHarvested(spellStats, world, pos1) || origState.m_60734_() != state.m_60734_() || world.m_8055_(pos1).m_60767_() != Material.f_76296_ && world.m_8055_(pos1).m_60734_() == BlockRegistry.INTANGIBLE_AIR || !BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, pos1)) continue;
            if (this.isRealPlayer((Entity)shooter) && spellContext.castingTile == null) {
                firstBlock = this.swapFromInv((List<ItemStack>)list, origState, world, pos1, result, shooter, 9, firstBlock, (Player)fakePlayer, spellContext, resolver);
                continue;
            }
            if ((!(spellContext.castingTile instanceof IPlaceBlockResponder) || !(spellContext.castingTile instanceof IPickupResponder)) && (!(shooter instanceof IPlaceBlockResponder) || !(shooter instanceof IPickupResponder))) continue;
            boolean shouldBreak = false;
            for (IItemHandler iItemHandler : handlers) {
                for (int slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    BlockItem item;
                    ItemStack stack = iItemHandler.getStackInSlot(slot);
                    Item item2 = stack.m_41720_();
                    if (!(item2 instanceof BlockItem) || (item = (BlockItem)item2).m_40614_() == origState.m_60734_()) continue;
                    if (firstBlock == null) {
                        firstBlock = item.m_40614_();
                    } else if (item.m_40614_() != firstBlock) continue;
                    ItemStack extracted = iItemHandler.extractItem(slot, 1, false);
                    if (this.attemptPlace(extracted, world, pos1, result, shooter, (Player)fakePlayer, spellContext, resolver)) {
                        shouldBreak = true;
                        break;
                    }
                    iItemHandler.insertItem(slot, extracted, false);
                }
                if (!shouldBreak) continue;
                continue block0;
            }
        }
    }

    public Block swapFromInv(List<ItemStack> inventory, BlockState origState, Level world, BlockPos pos1, BlockHitResult result, LivingEntity shooter, int slots, Block firstBlock, Player fakePlayer, SpellContext context, SpellResolver resolver) {
        for (int i = 0; i < slots; ++i) {
            BlockItem item;
            ItemStack stack = inventory.get(i);
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof BlockItem) || (item = (BlockItem)item2).m_40614_() == origState.m_60734_()) continue;
            if (firstBlock == null) {
                firstBlock = item.m_40614_();
            } else if (item.m_40614_() != firstBlock) continue;
            if (this.attemptPlace(stack, world, new BlockPos((Vec3i)pos1), result, shooter, fakePlayer, context, resolver)) break;
        }
        return firstBlock;
    }

    public boolean attemptPlace(ItemStack stack, Level world, BlockPos pos1, BlockHitResult result, LivingEntity shooter, Player fakePlayer, SpellContext spellContext, SpellResolver resolver) {
        BlockItem item = (BlockItem)stack.m_41720_();
        ItemStack tool = LootUtil.getDefaultFakeTool();
        tool.m_41663_(Enchantments.f_44985_, 1);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
        BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)new BlockPlaceContext(new UseOnContext(fakePlayer, InteractionHand.MAIN_HAND, result)), (BlockPos)pos1.m_142300_(result.m_82434_().m_122424_()), (Direction)result.m_82434_());
        BlockState placeState = item.m_40614_().m_5573_(context);
        Block.m_49881_((BlockState)world.m_8055_(pos1), (Level)world, (BlockPos)pos1, (BlockEntity)world.m_7702_(pos1), (Entity)shooter, (ItemStack)tool);
        BlockUtil.destroyBlockSafelyWithoutSound(world, pos1, false, shooter);
        if (placeState != null) {
            Player player;
            world.m_7731_(pos1, placeState, 3);
            item.m_40614_().m_6402_(world, pos1, placeState, shooter, stack);
            BlockItem.m_40582_((Level)world, (Player)(shooter instanceof Player ? (player = (Player)shooter) : fakePlayer), (BlockPos)pos1, (ItemStack)stack);
            stack.m_41774_(1);
            ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_()), result.m_82434_(), pos1, false), world, shooter, spellContext, resolver);
            return true;
        }
        return false;
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentPierce.INSTANCE, AugmentAOE.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "When used on blocks, exchanges the blocks in the players hotbar for the blocks hit as if they were mined with silk touch. Can be augmented with AOE, and Amplify is required for swapping blocks of higher hardness. When used on entities, the locations of the caster and the entity hit are swapped.";
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

