/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EffectDispel
extends AbstractEffect {
    public static EffectDispel INSTANCE = new EffectDispel();

    private EffectDispel() {
        super("dispel", "Dispel");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (rayTraceResult.m_82443_() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)rayTraceResult.m_82443_();
            Collection effects = entity.m_21220_();
            MobEffectInstance[] array = effects.toArray(new MobEffectInstance[0]);
            if (MinecraftForge.EVENT_BUS.post((Event)new DispelEvent((HitResult)rayTraceResult, world, shooter, spellStats.getAugments(), spellContext))) {
                return;
            }
            for (MobEffectInstance e : array) {
                if (!e.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_))) continue;
                entity.m_21195_(e.m_19544_());
            }
            if (entity instanceof IDispellable && entity.m_6084_() && entity.m_21223_() > 0.0f && !entity.m_146910_()) {
                ((IDispellable)entity).onDispel(shooter);
            }
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (world.m_8055_(rayTraceResult.m_82425_()) instanceof IDispellable) {
            ((IDispellable)world.m_8055_(rayTraceResult.m_82425_())).onDispel(shooter);
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return rayTraceResult instanceof EntityHitResult || rayTraceResult instanceof BlockHitResult && world.m_8055_(((BlockHitResult)rayTraceResult).m_82425_()).m_60734_() instanceof IDispellable;
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Removes any potion effects on the target. When used on a witch at half health, the witch will vanish in return for a Wixie shard. Will also dispel tamed summons back into their charm.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ABJURATION);
    }
}

