/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.light;

import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;

public class DynamLightUtil {
    public static int getSectionCoord(double coord) {
        return DynamLightUtil.getSectionCoord(Mth.m_14107_((double)coord));
    }

    public static int getSectionCoord(int coord) {
        return coord >> 4;
    }

    private static int getLuminance(Entity entity) {
        int level = 0;
        if (entity.m_6060_()) {
            return 15;
        }
        if (Config.ENTITY_LIGHT_MAP.containsKey(entity.m_6095_().getRegistryName())) {
            return Config.ENTITY_LIGHT_MAP.get(entity.m_6095_().getRegistryName());
        }
        if (LightManager.getLightRegistry().containsKey(entity.m_6095_())) {
            for (Function<Entity, Integer> function : LightManager.getLightRegistry().get(entity.m_6095_())) {
                int val = function.apply(entity);
                level = Math.max(val, level);
            }
        }
        return Math.min(15, level);
    }

    public static boolean couldGiveLight(Entity entity) {
        Player player;
        return LightManager.getLightRegistry().containsKey(entity.m_6095_()) || Config.ENTITY_LIGHT_MAP.containsKey(entity.m_6095_().getRegistryName()) || entity instanceof Player && DynamLightUtil.getPlayerLight(player = (Player)entity) > 0;
    }

    public static int getPlayerLight(Player player) {
        int mainLight = Config.ITEM_LIGHTMAP.getOrDefault(player.m_21205_().m_41720_().getRegistryName(), 0);
        int offHandLight = Config.ITEM_LIGHTMAP.getOrDefault(player.m_21206_().m_41720_().getRegistryName(), 0);
        return Math.max(mainLight, offHandLight);
    }

    public static int lightForEntity(Entity entity) {
        int light = 0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            light = DynamLightUtil.getPlayerLight(player);
        }
        if (light < 15 && LightManager.containsEntity((EntityType<? extends Entity>)entity.m_6095_())) {
            int entityLuminance = DynamLightUtil.getLuminance(entity);
            return Math.max(entityLuminance, light);
        }
        return Math.min(15, light);
    }

    public static int fromItemLike(ItemLike itemLike) {
        return Config.ITEM_LIGHTMAP.getOrDefault(itemLike.m_5456_().getRegistryName(), 0);
    }
}

