/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public abstract class ItemScroll
extends ModItem
implements IScribeable {
    public static String ITEM_PREFIX = "item_";

    public ItemScroll(String reg) {
        super(reg);
    }

    public ItemScroll(Item.Properties properties, String reg) {
        super(properties, reg);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
    }

    public abstract SortPref getSortPref(ItemStack var1, CompoundTag var2, IItemHandler var3);

    public List<ItemStack> getItems(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (tag == null) {
            return stacks;
        }
        for (String s : tag.m_128431_()) {
            if (!s.contains(ITEM_PREFIX)) continue;
            stacks.add(ItemStack.m_41712_((CompoundTag)tag.m_128469_(s)));
        }
        return stacks;
    }

    public static boolean addItem(ItemStack itemToAdd, CompoundTag tag) {
        CompoundTag itemTag = new CompoundTag();
        itemToAdd.m_41739_(itemTag);
        tag.m_128365_(ItemScroll.getItemKey(itemToAdd), (Tag)itemTag);
        return true;
    }

    public static boolean removeItem(ItemStack itemToRemove, CompoundTag tag) {
        tag.m_128473_(ItemScroll.getItemKey(itemToRemove));
        return true;
    }

    public static boolean containsItem(ItemStack stack, CompoundTag tag) {
        return tag != null && tag.m_128441_(ItemScroll.getItemKey(stack));
    }

    public static String getItemKey(ItemStack stack) {
        return ITEM_PREFIX + stack.m_41720_().getRegistryName().toString();
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        return ItemScroll.scribe(world, pos, player, handIn, thisStack);
    }

    public static boolean scribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        ItemStack stackToWrite = player.m_21120_(handIn);
        CompoundTag tag = thisStack.m_41783_();
        if (stackToWrite == ItemStack.f_41583_ || tag == null) {
            return false;
        }
        if (ItemScroll.containsItem(stackToWrite, tag)) {
            PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.scribe.item_removed"));
            return ItemScroll.removeItem(stackToWrite, tag);
        }
        PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.scribe.item_added"));
        return ItemScroll.addItem(stackToWrite, tag);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String string : tag.m_128431_()) {
            if (!string.contains(ITEM_PREFIX)) continue;
            stacks.add(ItemStack.m_41712_((CompoundTag)tag.m_128469_(string)));
        }
        for (ItemStack itemStack : stacks) {
            tooltip2.add(itemStack.m_41786_());
        }
    }

    public static enum SortPref {
        INVALID,
        LOW,
        HIGH,
        HIGHEST;

    }
}

