/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.client.IVariantTextureProvider;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.PotionEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class FamiliarWixie
extends FlyingFamiliarEntity
implements IAnimationListener,
IVariantTextureProvider {
    public int debuffCooldown;

    public FamiliarWixie(EntityType<? extends PathfinderMob> ent, Level world) {
        super(ent, world);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_ || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21205_().m_204117_(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.f_19804_.m_135370_(COLOR)).equals(color.m_41065_()) || !Arrays.asList(EntityWixie.COLORS).contains(color.m_41065_())) {
                return InteractionResult.SUCCESS;
            }
            this.setColor(color);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void potionEvent(PotionEvent.PotionAddedEvent event) {
        if (!this.m_6084_()) {
            return;
        }
        if (event.getEntity() != null && !event.getEntity().f_19853_.f_46443_ && event.getEntity().equals((Object)this.getOwner())) {
            event.getPotionEffect().f_19503_ = (int)((double)event.getPotionEffect().f_19503_ + (double)event.getPotionEffect().f_19503_ * 0.2);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new DebuffTargetGoal(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.debuffCooldown > 0) {
            --this.debuffCooldown;
        }
    }

    @Override
    public PlayState walkPredicate(AnimationEvent event) {
        if (this.m_21573_().m_26572_()) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        super.registerControllers(data);
        data.addAnimationController(new AnimationController((IAnimatable)this, "castController", 1.0f, a -> PlayState.CONTINUE));
    }

    public EntityType<?> m_6095_() {
        return ModEntities.ENTITY_FAMILIAR_WIXIE;
    }

    @Override
    public void startAnimation(int arg) {
        if (arg == EntityWixie.Animations.CAST.ordinal()) {
            AnimationController controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("castController");
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("cast", Boolean.valueOf(false)));
        }
    }

    @Override
    public ResourceLocation getTexture(LivingEntity entity) {
        String color = ((String)this.m_20088_().m_135370_(COLOR)).toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/wixie_" + color + ".png");
    }

    public static class DebuffTargetGoal
    extends Goal {
        FamiliarWixie wixie;
        public static ArrayList<MobEffect> effectTable = new ArrayList<MobEffect>(Arrays.asList(MobEffects.f_19597_, MobEffects.f_19613_, MobEffects.f_19620_, MobEffects.f_19614_));

        public DebuffTargetGoal(FamiliarWixie wixie) {
            this.wixie = wixie;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.wixie.m_5448_() == null) {
                return;
            }
            MobEffect effect = effectTable.get(new Random().nextInt(effectTable.size()));
            if (effect == MobEffects.f_19614_ && this.wixie.m_5448_().m_21222_()) {
                effect = MobEffects.f_19605_;
            }
            Networking.sendToNearby(this.wixie.f_19853_, (Entity)this.wixie, (Object)new PacketAnimEntity(this.wixie.m_142049_(), EntityWixie.Animations.CAST.ordinal()));
            this.wixie.m_5448_().m_7292_(new MobEffectInstance(effect, 140, new Random().nextInt(2)));
            this.wixie.debuffCooldown = 150;
        }

        public boolean m_8036_() {
            return this.wixie.debuffCooldown <= 0 && this.wixie.m_5448_() != null;
        }
    }
}

