/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Tuple;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.logging.log4j.LogManager;

public class DataDumpCommand {
    public static final Path PATH_AUGMENT_COMPATIBILITY = Paths.get("ars_nouveau", "augment_compatibility.csv");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ars-data").requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"dump").then(Commands.m_82127_((String)"augment-compatibility-csv").executes(DataDumpCommand::dumpAugmentCompat))));
    }

    public static int dumpAugmentCompat(CommandContext<CommandSourceStack> context) {
        Map<String, AbstractSpellPart> spells = ArsNouveauAPI.getInstance().getSpellpartMap();
        List augments = spells.values().stream().filter(p -> p instanceof AbstractAugment).map(p -> (AbstractAugment)p).sorted(Comparator.comparing(a -> a.getId())).collect(Collectors.toList());
        List augmentCompat = spells.values().stream().filter(part -> part instanceof AbstractCastMethod).map(part -> new Tuple(part, part.compatibleAugments)).sorted(Comparator.comparing(t -> ((AbstractSpellPart)t.m_14418_()).getId())).collect(Collectors.toList());
        augmentCompat.addAll(spells.values().stream().filter(part -> part instanceof AbstractEffect).map(part -> new Tuple(part, part.compatibleAugments)).sorted(Comparator.comparing(t -> ((AbstractSpellPart)t.m_14418_()).getId())).collect(Collectors.toList()));
        File file = PATH_AUGMENT_COMPATIBILITY.toFile();
        try {
            Files.createDirectories(PATH_AUGMENT_COMPATIBILITY.getParent(), new FileAttribute[0]);
            PrintWriter w = new PrintWriter((Writer)new FileWriterWithEncoding(file, "UTF-8", false));
            w.println("glyph, " + augments.stream().map(a -> a.getId()).collect(Collectors.joining(", ")));
            for (Tuple row : augmentCompat) {
                AbstractSpellPart part2 = (AbstractSpellPart)row.m_14418_();
                Set compatibleAugments = (Set)row.m_14419_();
                w.print(part2.getId() + ", ");
                w.print(augments.stream().map(a -> compatibleAugments.contains(a) ? "T" : "F").collect(Collectors.joining(", ")));
                w.println();
            }
            w.close();
        }
        catch (IOException ex) {
            LogManager.getLogger((String)"ars_nouveau").error("Unable to dump augment compatibility chart", (Throwable)ex);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Error when trying to produce the data dump.  Check the logs."));
            return 0;
        }
        catch (Exception ex) {
            LogManager.getLogger((String)"ars_nouveau").error("Exception caught when trying to dump data", (Throwable)ex);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Error when trying to produce the data dump.  Check the logs."));
            throw ex;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Dumped data to " + file), true);
        return 1;
    }
}

