/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.client.jei.JEIConstants;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CrushRecipeCategory
implements IRecipeCategory<CrushRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ars_nouveau", "crush");
    IGuiHelper helper;
    public IDrawable background;
    public IDrawable icon;
    public List<CrushRecipe.CrushOutput> outputs = new ArrayList<CrushRecipe.CrushOutput>();
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CrushRecipeCategory(final IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createBlankDrawable(60, 50);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ArsNouveauAPI.getInstance().getGlyphItem(EffectCrush.INSTANCE).m_7968_());
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(JEIConstants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrushRecipe> getRecipeClass() {
        return CrushRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("ars_nouveau.crush_recipe");
    }

    public IDrawable getBackground() {
        return this.helper.createBlankDrawable(120, 8 + 16 * this.outputs.size());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrushRecipe recipe, @Nonnull IRecipeSlotsView slotsView, @Nonnull PoseStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(matrixStack, 30, 6);
        Font renderer = Minecraft.m_91087_().f_91062_;
        for (int i = 0; i < recipe.outputs.size(); ++i) {
            renderer.m_92883_(matrixStack, Math.round(100.0f * recipe.outputs.get((int)i).chance - 0.5f) + "%", 85.0f, 11.0f + 17.0f * (float)i, 10);
        }
    }

    public void setIngredients(CrushRecipe o, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.add(Arrays.asList(o.input.m_43908_()));
        iIngredients.setInputLists((IIngredientType)VanillaTypes.ITEM_STACK, inputs);
        iIngredients.setOutputs((IIngredientType)VanillaTypes.ITEM_STACK, o.outputs.stream().map(c -> c.stack).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrushRecipe o, IIngredients ingredients) {
        int index = 0;
        this.outputs = o.outputs;
        recipeLayout.getItemStacks().init(index, true, 6, 5);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs((IIngredientType)VanillaTypes.ITEM_STACK).get(0));
        ++index;
        for (int i = 0; i < ingredients.getOutputs((IIngredientType)VanillaTypes.ITEM_STACK).size(); ++i) {
            recipeLayout.getItemStacks().init(index, true, 60, 5 + 16 * i);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs((IIngredientType)VanillaTypes.ITEM_STACK).get(i));
            ++index;
        }
    }
}

