/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockUtil {
    public static BlockPos toPos(Vec3 vec) {
        return new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public static boolean isTreeBlock(BlockState block) {
        return block.m_204336_(BlockTags.f_13035_) || block.m_204336_(BlockTags.f_13106_);
    }

    public static boolean containsStateInRadius(Level world, BlockPos start, int radius, Class clazz) {
        for (double x = (double)(start.m_123341_() - radius); x <= (double)(start.m_123341_() + radius); x += 1.0) {
            for (double y = (double)(start.m_123342_() - radius); y <= (double)(start.m_123342_() + radius); y += 1.0) {
                for (double z = (double)(start.m_123343_() - radius); z <= (double)(start.m_123343_() + radius); z += 1.0) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos.equals((Object)start) || !world.m_8055_(pos).m_60734_().getClass().equals(clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double distanceFrom(BlockPos start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.m_123341_() - end.m_123341_(), 2.0) + Math.pow(start.m_123342_() - end.m_123342_(), 2.0) + Math.pow(start.m_123343_() - end.m_123343_(), 2.0));
    }

    public static double distanceFrom(Vec3 start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.f_82479_ - (double)end.m_123341_(), 2.0) + Math.pow(start.f_82480_ - (double)end.m_123342_(), 2.0) + Math.pow(start.f_82481_ - (double)end.m_123343_(), 2.0));
    }

    public static double distanceFrom(Vec3 start, Vec3 end) {
        return Math.sqrt(Math.pow(start.f_82479_ - end.f_82479_, 2.0) + Math.pow(start.f_82480_ - end.f_82480_, 2.0) + Math.pow(start.f_82481_ - end.f_82481_, 2.0));
    }

    public static boolean destroyBlockSafely(Level world, BlockPos pos, boolean dropBlock, LivingEntity caster) {
        Object playerEntity;
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        Object object = playerEntity = caster instanceof Player ? (Player)caster : ANFakePlayer.getPlayer((ServerLevel)world);
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), playerEntity))) {
            return false;
        }
        world.m_8055_(pos).m_60734_().m_5707_(world, pos, world.m_8055_(pos), playerEntity);
        return world.m_46961_(pos, dropBlock);
    }

    public static boolean destroyRespectsClaim(LivingEntity caster, Level world, BlockPos pos) {
        Object playerEntity = caster instanceof Player ? (Player)caster : ANFakePlayer.getPlayer((ServerLevel)world);
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), playerEntity));
    }

    public static void safelyUpdateState(Level world, BlockPos pos, BlockState state) {
        if (!world.m_151570_(pos)) {
            world.m_7260_(pos, state, state, 3);
        }
    }

    public static void safelyUpdateState(Level world, BlockPos pos) {
        BlockUtil.safelyUpdateState(world, pos, world.m_8055_(pos));
    }

    public static boolean destroyBlockSafelyWithoutSound(Level world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    public static boolean destroyBlockSafelyWithoutSound(Level world, BlockPos pos, boolean dropBlock, @Nullable LivingEntity caster) {
        Object playerEntity;
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        Object object = playerEntity = caster instanceof Player ? (Player)caster : ANFakePlayer.getPlayer((ServerLevel)world);
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), playerEntity))) {
            return false;
        }
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock);
    }

    private static boolean destroyBlockWithoutSound(Level world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    private static boolean destroyBlockWithoutSound(Level world, BlockPos pos, boolean isMoving, @Nullable Entity entityIn) {
        BlockState blockstate = world.m_8055_(pos);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState ifluidstate = world.m_6425_(pos);
        if (isMoving) {
            BlockEntity tileentity = blockstate.m_155947_() ? world.m_7702_(pos) : null;
            Block.m_49881_((BlockState)blockstate, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.f_41583_);
        }
        return world.m_7731_(pos, ifluidstate.m_76188_(), 3);
    }

    public static List<IItemHandler> getAdjacentInventories(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return new ArrayList<IItemHandler>();
        }
        ArrayList<IItemHandler> iInventories = new ArrayList<IItemHandler>();
        for (Direction d : Direction.values()) {
            BlockEntity tileEntity = world.m_7702_(pos.m_142300_(d));
            if (tileEntity == null || !tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) continue;
            iInventories.add((IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
        }
        return iInventories;
    }

    public static ItemStack insertItemAdjacent(Level world, BlockPos pos, ItemStack stack) {
        for (IItemHandler i : BlockUtil.getAdjacentInventories(world, pos)) {
            if (stack == ItemStack.f_41583_ || stack == null) break;
            stack = ItemHandlerHelper.insertItemStacked((IItemHandler)i, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack getItemAdjacent(Level world, BlockPos pos, Predicate<ItemStack> matchPredicate, int amount) {
        for (IItemHandler inv : BlockUtil.getAdjacentInventories(world, pos)) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!matchPredicate.test(inv.getStackInSlot(i))) continue;
                return inv.extractItem(i, amount, false);
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean canBlockBeHarvested(SpellStats stats, Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60800_((BlockGetter)world, pos) >= 0.0f && SpellUtil.isCorrectHarvestLevel(BlockUtil.getBaseHarvestLevel(stats), world.m_8055_(pos));
    }

    public static int getBaseHarvestLevel(SpellStats stats) {
        return (int)(3.0 + stats.getAmpMultiplier());
    }

    public static List<BlockPos> getLine(int x0, int y0, int x1, int y1, float wd) {
        ArrayList<BlockPos> vects = new ArrayList<BlockPos>();
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        float ed = dx + dy == 0 ? 1.0f : Mth.m_14116_((float)((float)dx * (float)dx + (float)dy * (float)dy));
        wd = (wd + 1.0f) / 2.0f;
        while (true) {
            vects.add(new BlockPos(x0, 0, y0));
            int e2 = err;
            int x2 = x0;
            if (2 * e2 >= -dx) {
                e2 += dy;
                int y2 = y0;
                while ((float)e2 < ed * wd && (y1 != y2 || dx > dy)) {
                    vects.add(new BlockPos(x0, 0, y2 += sy));
                    e2 += dx;
                }
                if (x0 == x1) break;
                e2 = err;
                err -= dy;
                x0 += sx;
            }
            if (2 * e2 > dy) continue;
            e2 = dx - e2;
            while ((float)e2 < ed * wd && (x1 != x2 || dx < dy)) {
                vects.add(new BlockPos(x2 += sx, 0, y0));
                e2 += dy;
            }
            if (y0 == y1) break;
            err += dx;
            y0 += sy;
        }
        return vects;
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(Level world, BlockPos point, int radiusX, int radiusY, int radiusZ, int height) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int j = point.m_123342_(); j <= point.m_123342_() + radiusY; ++j) {
            for (int i = point.m_123341_() - radiusX; i <= point.m_123341_() + radiusX; ++i) {
                for (int k = point.m_123343_() - radiusZ; k <= point.m_123343_() + radiusZ; ++k) {
                    BlockPos tempCoords;
                    if (!BlockUtil.wontSuffocate(world, i, j, k, height) || !world.m_8055_((tempCoords = new BlockPos(i, j, k)).m_7495_()).m_60767_().m_76333_() && !world.m_8055_(tempCoords.m_6625_(2)).m_60767_().m_76333_()) continue;
                    double distance = BlockUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean wontSuffocate(Level world, int x, int y, int z, int height) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.m_8055_(new BlockPos(x, y + dy, z));
            if (!state.m_60767_().m_76334_()) continue;
            return false;
        }
        return true;
    }

    public static long getDistanceSquared(BlockPos block1, BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.m_123341_() - (long)block2.m_123341_();
        long result = xDiff * xDiff + (yDiff = (long)block1.m_123342_() - (long)block2.m_123342_()) * yDiff + (zDiff = (long)block1.m_123343_() - (long)block2.m_123343_()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    private BlockUtil() {
    }
}

