/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.loot;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.datagen.DungeonLootGenerator;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDispel;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExplosion;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFirework;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLight;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPhantomBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonDecoy;
import com.hollingsworth.arsnouveau.common.spell.method.MethodOrbit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class DungeonLootTables {
    public static List<Supplier<ItemStack>> BASIC_LOOT = new ArrayList<Supplier<ItemStack>>();
    public static List<Supplier<ItemStack>> UNCOMMON_LOOT = new ArrayList<Supplier<ItemStack>>();
    public static List<Supplier<ItemStack>> RARE_LOOT = new ArrayList<Supplier<ItemStack>>();
    public static Random r = new Random();

    public static ItemStack getRandomItem(List<Supplier<ItemStack>> pool) {
        return pool.isEmpty() ? ItemStack.f_41583_ : pool.get(r.nextInt(pool.size())).get();
    }

    public static List<ItemStack> getRandomRoll(DungeonLootGenerator.DungeonLootEnhancerModifier modifier) {
        int i;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (i = 0; i < modifier.commonRolls; ++i) {
            if (!(r.nextDouble() <= modifier.commonChance)) continue;
            stacks.add(DungeonLootTables.getRandomItem(BASIC_LOOT));
        }
        for (i = 0; i < modifier.uncommonRolls; ++i) {
            if (!(r.nextDouble() <= modifier.uncommonChance)) continue;
            stacks.add(DungeonLootTables.getRandomItem(UNCOMMON_LOOT));
        }
        if (((Boolean)Config.SPAWN_TOMES.get()).booleanValue()) {
            for (i = 0; i < modifier.rareRolls; ++i) {
                if (!(r.nextDouble() <= modifier.rareChance)) continue;
                stacks.add(DungeonLootTables.getRandomItem(RARE_LOOT));
            }
        }
        return stacks;
    }

    public static ItemStack makeTome(String name, Spell spell) {
        ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.CASTER_TOME);
        ISpellCaster spellCaster = CasterUtil.getCaster(stack);
        spellCaster.setSpell(spell);
        stack.m_41714_((Component)new TextComponent(name).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(true))));
        return stack;
    }

    public static ItemStack makeTome(String name, Spell spell, String flavorText) {
        ItemStack stack = DungeonLootTables.makeTome(name, spell);
        ISpellCaster spellCaster = CasterUtil.getCaster(stack);
        spellCaster.setFlavorText(flavorText);
        return stack;
    }

    public static ItemStack makeTome(String name, Spell spell, String flavorText, ParticleColor particleColor) {
        ItemStack stack = DungeonLootTables.makeTome(name, spell);
        ISpellCaster spellCaster = CasterUtil.getCaster(stack);
        spellCaster.setFlavorText(flavorText);
        spellCaster.setColor(particleColor.toWrapper());
        return stack;
    }

    static {
        BASIC_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.SOURCE_GEM, 1 + r.nextInt(5)));
        BASIC_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.WILDEN_HORN, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.WILDEN_SPIKE, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.WILDEN_WING, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)stack, (Potion)ModPotions.LONG_MANA_REGEN_POTION);
            return stack;
        });
        BASIC_LOOT.add(() -> {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)stack, (Potion)ModPotions.STRONG_MANA_REGEN_POTION);
            return stack;
        });
        BASIC_LOOT.add(() -> {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)stack, (Potion)ModPotions.MANA_REGEN_POTION);
            return stack;
        });
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.WARP_SCROLL, 1 + r.nextInt(2)));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_SHARD));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.WHIRLISPRIG_SHARDS));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.DRYGMY_SHARD));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.WIXIE_SHARD));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.AMPLIFY_ARROW, 16 + r.nextInt(16)));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.SPLIT_ARROW, 16 + r.nextInt(16)));
        UNCOMMON_LOOT.add(() -> new ItemStack((ItemLike)ItemsRegistry.PIERCE_ARROW, 16 + r.nextInt(16)));
        UNCOMMON_LOOT.add(() -> {
            ArrayList<RitualTablet> tablets = new ArrayList<RitualTablet>(ArsNouveauAPI.getInstance().getRitualItemMap().values());
            return new ItemStack((ItemLike)tablets.get(r.nextInt(tablets.size())));
        });
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Xacris' Tiny Hut", new Spell().add((AbstractSpellPart)MethodUnderfoot.INSTANCE).add((AbstractSpellPart)EffectPhantomBlock.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 3).add((AbstractSpellPart)AugmentPierce.INSTANCE, 3), "Builds a small hut around the user."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Glow Trap", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectSnare.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)EffectLight.INSTANCE), "Snares the target and grants other targets Glowing."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Bailey's Bovine Rocket", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE)));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Arachne's Weaving", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentSplit.INSTANCE, 2).add((AbstractSpellPart)EffectSnare.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Creates three snaring projectiles."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Warp Impact", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE), "Teleportation, with style!"));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Farfalla's Frosty Flames", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectConjureWater.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE), "Creates a fire that quickly freezes to ice."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Gootastic's Telekinetic Fishing Rod", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectPull.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "The squid's Lovecraftian roots appear to make it immune."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Potent Toxin", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectHex.INSTANCE).add((AbstractSpellPart)EffectHarm.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Poisons that target and causes them to take additional damage from all sources."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("The Shadow's Temporary Tunnel", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectIntangible.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2).add((AbstractSpellPart)AugmentPierce.INSTANCE, 5).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Creates a temporary tunnel of blocks."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Vault", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectLeap.INSTANCE).add((AbstractSpellPart)EffectSlowfall.INSTANCE), "Sometimes you just need to get over that wall."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Fireball!", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2), "A classic."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Rune of Renewing", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectDispel.INSTANCE).add((AbstractSpellPart)EffectHeal.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Cures status effects and heals the user."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Knocked out of Orbit", new Spell().add((AbstractSpellPart)MethodOrbit.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectKnockback.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "Summons orbiting projectiles that will launch nearby enemies."));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Takeoff!", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE, 2).add((AbstractSpellPart)EffectGlide.INSTANCE).add((AbstractSpellPart)AugmentDurationDown.INSTANCE), "Launches the caster into the air and grants temporary elytra flight!"));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("KirinDave's Sinister Switch", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonDecoy.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Heroes are so straightforward, so easily befuddled...", new ParticleColor(25, 255, 255)));
        RARE_LOOT.add(() -> DungeonLootTables.makeTome("Xacris's Firework Display", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE).add((AbstractSpellPart)EffectFirework.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 4).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Light up the sky", new ParticleColor(255, 255, 255)));
    }
}

