/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class ChimeraSummonEvent
implements ITimedEvent {
    int duration;
    int phase;
    Level world;
    BlockPos pos;
    int ownerID;
    public static final String ID = "chimera";

    public ChimeraSummonEvent(int duration, int phase, Level world, BlockPos pos, int ownerID) {
        this.duration = duration;
        this.phase = phase;
        this.world = world;
        this.pos = pos;
        this.ownerID = ownerID;
    }

    public static ChimeraSummonEvent get(CompoundTag tag) {
        return new ChimeraSummonEvent(tag.m_128451_("duration"), tag.m_128451_("phase"), ArsNouveau.proxy.getClientWorld(), NBTUtil.getBlockPos(tag, "loc"), -1);
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (serverSide) {
            Entity owner = this.world.m_6815_(this.ownerID);
            if (!(owner instanceof EntityChimera)) {
                this.duration = 0;
                return;
            }
            EntityChimera boss = (EntityChimera)owner;
            boolean summonedWilden = false;
            if (this.duration % 20 == 0) {
                Random random = boss.m_21187_();
                SummonWolf wolf = new SummonWolf(ModEntities.SUMMON_WOLF, this.world);
                wolf.m_6034_(this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_());
                wolf.isWildenSummon = true;
                wolf.ticksLeft = 100 + this.phase * 60;
                this.summon((Mob)wolf, this.getPos(), boss.m_5448_());
                int randBound = 10 - boss.getPhase();
                if (!summonedWilden && boss.hasWings() && boss.f_19853_.f_46441_.nextInt(randBound) == 0) {
                    WildenStalker stalker = new WildenStalker(ModEntities.WILDEN_STALKER, this.world);
                    this.summon((Mob)stalker, this.getPos(), boss.m_5448_());
                    summonedWilden = true;
                }
                if (boss.hasHorns() && boss.f_19853_.f_46441_.nextInt(randBound) == 0) {
                    WildenHunter hunter = new WildenHunter(ModEntities.WILDEN_HUNTER, this.world);
                    this.summon((Mob)hunter, this.getPos(), boss.m_5448_());
                    summonedWilden = true;
                }
                if (!summonedWilden && boss.hasSpikes() && boss.f_19853_.f_46441_.nextInt(randBound) == 0) {
                    WildenGuardian guardian = new WildenGuardian(ModEntities.WILDEN_GUARDIAN, this.world);
                    this.summon((Mob)guardian, this.getPos(), boss.m_5448_());
                    summonedWilden = true;
                }
            }
        } else {
            ParticleUtil.spawnRitualAreaEffect(this.pos, this.world, this.world.f_46441_, ParticleUtil.defaultParticleColor(), 1 + this.phase * 2);
        }
    }

    public void summon(Mob mob, BlockPos pos, @Nullable LivingEntity target) {
        mob.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        mob.m_6710_(target);
        mob.m_21561_(true);
        mob.f_19853_.m_7967_((Entity)mob);
    }

    public BlockPos getPos() {
        double spawnArea = 2.5 + (double)(this.phase * 2);
        return new BlockPos((double)this.pos.m_123341_() + ParticleUtil.inRange(-spawnArea, spawnArea), (double)(this.pos.m_123342_() + 2), (double)this.pos.m_123343_() + ParticleUtil.inRange(-spawnArea, spawnArea));
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        ITimedEvent.super.serialize(tag);
        tag.m_128405_("duration", this.duration);
        tag.m_128405_("phase", this.phase);
        NBTUtil.storeBlockPos(tag, "loc", this.pos);
        return tag;
    }

    @Override
    public String getID() {
        return ID;
    }
}

