/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ToasterBlockEntity
extends BalmBlockEntity {
    private static final int TOAST_TICKS = 1200;
    private final DefaultContainer container = new DefaultContainer(2){

        public void m_6596_() {
            ToasterBlockEntity.this.m_6596_();
            ToasterBlockEntity.this.sync();
        }
    };
    private boolean active;
    private int toastTicks;

    public ToasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.toaster.get(), pos, state);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.toasterStart.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 1) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.toasterStop.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 2) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.container.deserialize(tagCompound.m_128469_("ItemHandler"));
        this.active = tagCompound.m_128471_("Active");
        this.toastTicks = tagCompound.m_128451_("ToastTicks");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ItemHandler", (Tag)this.container.serialize());
        tag.m_128379_("Active", this.active);
        tag.m_128405_("ToastTicks", this.toastTicks);
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !level.f_46443_) {
                for (int i = 0; i < this.container.m_6643_(); ++i) {
                    ItemStack inputStack = this.container.m_8020_(i);
                    if (inputStack.m_41619_()) continue;
                    ToasterHandler toastHandler = CookingRegistry.getToasterHandler(inputStack);
                    ItemStack outputStack = toastHandler.getToasterOutput(inputStack);
                    outputStack = outputStack.m_41619_() ? inputStack : outputStack.m_41777_();
                    ItemEntity itemEntity = new ItemEntity(level, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.75f), (double)((float)this.f_58858_.m_123343_() + 0.5f), outputStack);
                    itemEntity.m_20334_(0.0, (double)0.1f, 0.0);
                    level.m_7967_((Entity)itemEntity);
                    this.container.m_6836_(i, ItemStack.f_41583_);
                }
                this.setActive(false);
            }
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.toastTicks = 1200;
            this.f_58857_.m_7696_(this.f_58858_, ModBlocks.toaster, 0, 0);
        } else {
            this.toastTicks = 0;
            this.f_58857_.m_7696_(this.f_58858_, ModBlocks.toaster, 1, 0);
        }
        this.f_58857_.m_7696_(this.f_58858_, ModBlocks.toaster, 2, 0);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)ToasterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.m_6596_();
    }

    public boolean isActive() {
        return this.active;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }

    public Container getContainer() {
        return this.container;
    }
}

