/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockTile;
import com.supermartijn642.entangled.EntangledConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntangledBlockTileRenderer
implements BlockEntityRenderer<EntangledBlockTile> {
    private static int depth = 0;

    public void render(EntangledBlockTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        VoxelShape shape;
        if (!tile.isBound()) {
            return;
        }
        BlockEntity boundTile = tile.m_58904_().m_46472_() == tile.getBoundDimension() ? tile.m_58904_().m_7702_(tile.getBoundBlockPos()) : null;
        BlockState boundState = tile.getBoundBlockState();
        boolean renderTile = boundTile != null && EntangledBlockTileRenderer.canRenderTileEntity(boundTile.m_58903_().getRegistryName());
        boolean renderBlock = boundState != null && boundState.m_60799_() == RenderShape.MODEL && EntangledBlockTileRenderer.canRenderBlock(boundState.m_60734_().getRegistryName());
        AABB bounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (renderBlock && tile.m_58904_().m_46472_() == tile.getBoundDimension() && !(shape = boundState.m_60768_((BlockGetter)tile.m_58904_(), tile.getBoundBlockPos())).m_83281_()) {
            bounds = shape.m_83215_();
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        if (EntangledConfig.rotateRenderedBlock.get().booleanValue()) {
            float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 360.0f;
            float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 360.0f;
            float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 360.0f;
            matrixStack.m_85845_(new Quaternion(angleX, angleY, angleZ, true));
        }
        float scale = 0.4763f / (float)Math.sqrt((bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_()) / 4.0);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85837_(-bounds.m_82399_().f_82479_, -bounds.m_82399_().f_82480_, -bounds.m_82399_().f_82481_);
        if (renderTile && (!(boundTile instanceof EntangledBlockTile) || depth < 10)) {
            ++depth;
            ClientUtils.getMinecraft().m_167982_().m_112267_(boundTile, partialTicks, matrixStack, buffer);
            --depth;
        }
        if (renderBlock) {
            Minecraft.m_91087_().m_91289_().m_110912_(boundState, matrixStack, buffer, combinedLight, combinedOverlay);
        }
        matrixStack.m_85849_();
    }

    private static boolean canRenderBlock(ResourceLocation block) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(block.m_135827_()) && !Entangled.RENDER_BLACKLISTED_BLOCKS.contains(block);
    }

    private static boolean canRenderTileEntity(ResourceLocation tile) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(tile.m_135827_()) && !Entangled.RENDER_BLACKLISTED_TILE_ENTITIES.contains(tile);
    }
}

