/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockTile;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntangledBlock
extends BaseBlock
implements EntityBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");

    public EntangledBlock() {
        super("block", true, BlockBehaviour.Properties.m_60939_((Material)new Material.Builder(MaterialColor.f_76362_).m_76354_().m_76359_()).m_60956_(1.0f).m_60918_(SoundType.f_56742_).m_60978_(2.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult result) {
        if (worldIn.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerIn.m_21120_(hand);
        if (playerIn.m_6047_() && stack.m_41619_() && ((Boolean)state.m_61143_((Property)ON)).booleanValue()) {
            ((EntangledBlockTile)worldIn.m_7702_(pos)).bind(null, null);
            playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.unbind").color(ChatFormatting.YELLOW).get(), true);
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(false)));
        } else if (stack.m_41720_() == Entangled.item) {
            CompoundTag compound = stack.m_41783_();
            if (compound == null || !compound.m_128471_("bound")) {
                playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.no_selection").color(ChatFormatting.RED).get(), true);
            } else {
                BlockPos pos2 = new BlockPos(compound.m_128451_("boundx"), compound.m_128451_("boundy"), compound.m_128451_("boundz"));
                if (pos2.equals((Object)pos)) {
                    playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.self").color(ChatFormatting.RED).get(), true);
                } else {
                    if (!((Boolean)worldIn.m_8055_(pos).m_61143_((Property)ON)).booleanValue()) {
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(true)));
                    }
                    EntangledBlockTile tile = (EntangledBlockTile)worldIn.m_7702_(pos);
                    if (compound.m_128461_("dimension").equals(worldIn.m_46472_().m_135782_().toString())) {
                        if (EntangledConfig.maxDistance.get() == -1 || pos.m_123314_((Vec3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                            tile.bind(pos2, compound.m_128461_("dimension"));
                            playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.bind").color(ChatFormatting.YELLOW).get(), true);
                        } else {
                            playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get(), true);
                        }
                    } else if (EntangledConfig.allowDimensional.get().booleanValue()) {
                        tile.bind(pos2, compound.m_128461_("dimension"));
                        playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.bind").color(ChatFormatting.YELLOW).get(), true);
                    } else {
                        playerIn.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get(), true);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EntangledBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == Entangled.tile ? (world2, pos, state2, entity) -> ((EntangledBlockTile)entity).tick() : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON});
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ON) != false ? Shapes.m_83040_() : Shapes.m_83144_();
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String key = EntangledConfig.allowDimensional.get().booleanValue() ? (EntangledConfig.maxDistance.get() == -1 ? "infinite_other_dimension" : "ranged_other_dimension") : (EntangledConfig.maxDistance.get() == -1 ? "infinite_same_dimension" : "ranged_same_dimension");
        MutableComponent maxDistance = TextComponents.string((String)Integer.toString(EntangledConfig.maxDistance.get())).color(ChatFormatting.GOLD).get();
        tooltip.add((Component)TextComponents.translation((String)("entangled.entangled_block.info." + key), (Object[])new Object[]{maxDistance}).color(ChatFormatting.AQUA).get());
        CompoundTag tag = stack.m_41784_().m_128469_("tileData");
        if (tag.m_128441_("bound") && tag.m_128471_("bound")) {
            int x = tag.m_128451_("boundx");
            int y = tag.m_128451_("boundy");
            int z = tag.m_128451_("boundz");
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")))).color(ChatFormatting.GOLD).get();
            MutableComponent name = TextComponents.blockState((BlockState)Block.m_49803_((int)tag.m_128451_("blockstate"))).color(ChatFormatting.GOLD).get();
            MutableComponent xText = TextComponents.string((String)Integer.toString(x)).color(ChatFormatting.GOLD).get();
            MutableComponent yText = TextComponents.string((String)Integer.toString(y)).color(ChatFormatting.GOLD).get();
            MutableComponent zText = TextComponents.string((String)Integer.toString(z)).color(ChatFormatting.GOLD).get();
            tooltip.add((Component)TextComponents.translation((String)"entangled.entangled_block.info.bound", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        CompoundTag compound = stack.m_41784_().m_128469_("tileData");
        if (compound.m_128471_("bound")) {
            Player player = context.m_43723_();
            BlockPos pos = context.m_8083_();
            BlockPos pos2 = new BlockPos(compound.m_128451_("boundx"), compound.m_128451_("boundy"), compound.m_128451_("boundz"));
            if (compound.m_128461_("dimension").equals(context.m_43725_().m_46472_().m_135782_().toString())) {
                if (EntangledConfig.maxDistance.get() >= 0 && !pos.m_123314_((Vec3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                    if (player != null && !context.m_43725_().f_46443_) {
                        player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get(), true);
                    }
                    return null;
                }
            } else if (!EntangledConfig.allowDimensional.get().booleanValue()) {
                if (player != null && !context.m_43725_().f_46443_) {
                    player.m_5661_((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get(), true);
                }
                return null;
            }
            return (BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.valueOf(true));
        }
        return this.m_49966_();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof EntangledBlockTile ? ((EntangledBlockTile)entity).getAnalogOutputSignal() : 0;
    }

    public boolean m_7899_(BlockState p_60571_) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof EntangledBlockTile ? ((EntangledBlockTile)entity).getRedstoneSignal(direction) : 0;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof EntangledBlockTile ? ((EntangledBlockTile)entity).getDirectRedstoneSignal(direction) : 0;
    }
}

