/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.items.porter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.setup.ForgeEventHandlers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;

public class ChargedPorterItem
extends Item
implements IEnergyItem,
INBTPreservingIngredient,
ITooltipSettings {
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;
    public static final ManualEntry MANUAL = ManualHelper.create((String)"rftoolsutility:machines/teleporter");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.parameter((String)"energy", this::getEnergyString), TooltipBuilder.parameter((String)"target", this::hasTarget, this::getTargetString), TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"energy", this::getEnergyString), TooltipBuilder.parameter((String)"target", this::hasTarget, this::getTargetString)});

    private String getEnergyString(ItemStack stack) {
        return Integer.toString(stack.m_41782_() ? stack.m_41783_().m_128451_("Energy") : 0);
    }

    private boolean hasTarget(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return tag.m_128441_("target");
        }
        return false;
    }

    private String getTargetString(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return Integer.toString(tag.m_128451_("target"));
        }
        return "<not set>";
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public ChargedPorterItem() {
        this((Integer)TeleportConfiguration.CHARGEDPORTER_MAXENERGY.get());
    }

    protected ChargedPorterItem(int capacity) {
        super(new Item.Properties().m_41487_(1).m_41499_(1).m_41491_(RFToolsUtility.setup.getTab()));
        this.capacity = capacity;
        this.maxReceive = (Integer)TeleportConfiguration.CHARGEDPORTER_RECEIVEPERTICK.get();
        this.maxExtract = 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41619_() != newStack.m_41619_()) {
            return true;
        }
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.f_46443_) {
            CompoundTag tagCompound = stack.m_41783_();
            if (tagCompound == null) {
                return;
            }
            if (!tagCompound.m_128441_("tpTimer")) {
                return;
            }
            if (!(entityIn instanceof Player)) {
                return;
            }
            Player player = (Player)entityIn;
            int timer = tagCompound.m_128451_("tpTimer");
            if (--timer <= 0) {
                tagCompound.m_128473_("tpTimer");
                TeleportDestinations destinations = TeleportDestinations.get(worldIn);
                int target = tagCompound.m_128451_("target");
                GlobalPos coordinate = destinations.getCoordinateForId(target);
                if (coordinate == null) {
                    Logging.message((Player)player, (String)(ChatFormatting.RED + "Something went wrong! The target has disappeared!"));
                    TeleportationTools.applyEffectForSeverity(player, 3, false);
                    return;
                }
                TeleportDestination destination = destinations.getDestination(coordinate);
                ForgeEventHandlers.addPlayerToTeleportHere(destination, player);
            } else {
                tagCompound.m_128405_("tpTimer", timer);
            }
        }
    }

    public static void initOverrides(ChargedPorterItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("rftoolsutility", "charge"), (stack, world, livingEntity, seed) -> {
            CompoundTag tagCompound = stack.m_41783_();
            int energy = tagCompound == null ? 0 : tagCompound.m_128451_("Energy");
            int level = 9 * energy / item.capacity;
            if (level < 0) {
                level = 0;
            } else if (level > 8) {
                level = 8;
            }
            return 9 - level;
        });
    }

    protected int getSpeedBonus() {
        return 1;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            this.startTeleport(stack, player, world);
        } else {
            this.selectReceiver(stack, world, player);
        }
        return super.m_7203_(world, player, hand);
    }

    protected void selectReceiver(ItemStack stack, Level world, Player player) {
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            BlockEntity te = world.m_7702_(pos);
            this.setTarget(stack, player, world, te);
        } else {
            this.startTeleport(stack, player, world);
        }
        return InteractionResult.SUCCESS;
    }

    private void startTeleport(ItemStack stack, Player player, Level world) {
        if (world.f_46443_) {
            return;
        }
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("target") || tagCompound.m_128451_("target") == -1) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "The charged porter has no target."));
            return;
        }
        if (tagCompound.m_128441_("tpTimer")) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Already teleporting!"));
            return;
        }
        int target = tagCompound.m_128451_("target");
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalPos coordinate = destinations.getCoordinateForId(target);
        if (coordinate == null) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Something went wrong! The target has disappeared!"));
            TeleportationTools.applyEffectForSeverity(player, 3, false);
            return;
        }
        TeleportDestination destination = destinations.getDestination(coordinate);
        if (!TeleportationTools.checkValidTeleport(player, (ResourceKey<Level>)world.m_46472_(), destination.getDimension())) {
            return;
        }
        BlockPos playerCoordinate = new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_());
        int cost = TeleportationTools.calculateRFCost(world, playerCoordinate, destination);
        long energy = this.getEnergyStoredL(stack);
        if ((long)(cost = (int)((float)cost * 1.5f)) > energy) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not enough energy to start the teleportation!"));
            return;
        }
        this.extractEnergyNoMax(stack, cost, false);
        int ticks = TeleportationTools.calculateTime(world, playerCoordinate, destination);
        tagCompound.m_128405_("tpTimer", ticks /= this.getSpeedBonus());
        Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Start teleportation!"));
    }

    private void setTarget(ItemStack stack, Player player, Level world, BlockEntity te) {
        if (world.f_46443_) {
            return;
        }
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
        }
        int id = -1;
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)te;
            TeleportDestination destination = receiver.updateDestination();
            if (!destination.checkAccess(world, player.m_142081_())) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "You have no access to target this receiver!"));
                return;
            }
            id = receiver.getId();
        }
        if (id != -1) {
            this.selectOnReceiver(player, world, tagCompound, id);
        } else {
            this.selectOnThinAir(player, world, tagCompound, stack);
        }
        stack.m_41751_(tagCompound);
    }

    protected void selectOnReceiver(Player player, Level world, CompoundTag tagCompound, int id) {
        Logging.message((Player)player, (String)("Charged porter target is set to " + id + "."));
        tagCompound.m_128405_("target", id);
    }

    protected void selectOnThinAir(Player player, Level world, CompoundTag tagCompound, ItemStack stack) {
        if (world.f_46443_) {
            Logging.message((Player)player, (String)"Charged porter is cleared.");
        }
        tagCompound.m_128473_("target");
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.m_41783_() == null) {
            container.m_41751_(new CompoundTag());
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, EnergyTools.unsignedClampToInt((long)maxReceive)));
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0L;
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, EnergyTools.unsignedClampToInt((long)maxExtract)));
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int extractEnergyNoMax(ItemStack container, int maxExtract, boolean simulate) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0;
        }
        int energy = container.m_41783_().m_128451_("Energy");
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            container.m_41783_().m_128405_("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0L;
        }
        return container.m_41783_().m_128451_("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return this.capacity;
    }

    public Collection<String> getTagsToPreserve() {
        return Arrays.asList("Energy");
    }
}

