/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.playerprops.FavoriteDestinationsProperties;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TeleportDestinations
extends AbstractWorldData<TeleportDestinations> {
    private static final String TPDESTINATIONS_NAME = "TPDestinations";
    private final Map<GlobalPos, TeleportDestination> destinations = new HashMap<GlobalPos, TeleportDestination>();
    private final Map<Integer, GlobalPos> destinationById = new HashMap<Integer, GlobalPos>();
    private final Map<GlobalPos, Integer> destinationIdByCoordinate = new HashMap<GlobalPos, Integer>();
    private int lastId = 0;

    public TeleportDestinations() {
    }

    public TeleportDestinations(CompoundTag tag) {
        this.lastId = tag.m_128451_("lastId");
        this.readDestinationsFromNBT(tag);
    }

    public static String getDestinationName(TeleportDestinations destinations, int receiverId) {
        Object name;
        GlobalPos coordinate = destinations.getCoordinateForId(receiverId);
        if (coordinate == null) {
            name = "?";
        } else {
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (destination == null) {
                name = "?";
            } else {
                name = destination.getName();
                if (name == null || ((String)name).isEmpty()) {
                    name = BlockPosTools.toString((BlockPos)destination.getCoordinate()) + " (" + destination.getDimension().m_135782_().m_135815_() + ")";
                }
            }
        }
        return name;
    }

    public void cleanupInvalid() {
        HashSet<GlobalPos> keys = new HashSet<GlobalPos>(this.destinations.keySet());
        for (GlobalPos key : keys) {
            ServerLevel transWorld = LevelTools.getLevel((ResourceKey)key.m_122640_());
            boolean removed = false;
            if (transWorld == null) {
                Logging.log((String)("Receiver on dimension " + key.m_122640_().m_135782_().m_135815_() + " removed because world can't be loaded!"));
                removed = true;
            } else {
                BlockEntity te;
                BlockPos c = key.m_122646_();
                try {
                    te = transWorld.m_7702_(c);
                }
                catch (Exception e) {
                    te = null;
                }
                if (!(te instanceof MatterReceiverTileEntity)) {
                    Logging.log((String)("Receiver at " + c + " on dimension " + key.m_122640_().m_135782_().m_135815_() + " removed because there is no receiver there!"));
                    removed = true;
                }
            }
            if (!removed) continue;
            this.destinations.remove(key);
        }
    }

    public static TeleportDestinations get(Level world) {
        return (TeleportDestinations)TeleportDestinations.getData((Level)world, TeleportDestinations::new, TeleportDestinations::new, (String)TPDESTINATIONS_NAME);
    }

    public Collection<TeleportDestinationClientInfo> getValidDestinations(Level level, UUID player) {
        FavoriteDestinationsProperties properties = null;
        if (player != null) {
            MinecraftServer server = level.m_142572_();
            List list = server.m_6846_().m_11314_();
            for (ServerPlayer entity : list) {
                if (!player.equals(entity.m_142081_())) continue;
                properties = PlayerExtendedProperties.getFavoriteDestinations((Player)entity).map(h -> h).orElse(null);
                break;
            }
        }
        ArrayList<TeleportDestinationClientInfo> result = new ArrayList<TeleportDestinationClientInfo>();
        for (TeleportDestination destination : this.destinations.values()) {
            TeleportDestinationClientInfo destinationClientInfo = new TeleportDestinationClientInfo(destination);
            BlockPos c = destination.getCoordinate();
            ServerLevel world = LevelTools.getLevel(destination.getDimension());
            String dimName = "<Unknown>";
            if (world != null) {
                dimName = world.m_46472_().m_135782_().m_135815_();
            }
            destinationClientInfo.setDimensionName(dimName);
            if (world != null) {
                BlockEntity te;
                if (!destination.isAccessKnown() && (te = world.m_7702_(c)) instanceof MatterReceiverTileEntity) {
                    MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)te;
                    destination = receiver.updateDestination();
                }
                if (destination.isAccessKnown() && player != null && !destination.checkAccess((Level)world, player)) continue;
            }
            if (properties != null) {
                destinationClientInfo.setFavorite(properties.isDestinationFavorite(GlobalPos.m_122643_(destination.getDimension(), (BlockPos)c)));
            }
            result.add(destinationClientInfo);
        }
        Collections.sort(result);
        return result;
    }

    public boolean isDestinationValid(TeleportDestination destination) {
        GlobalPos key = GlobalPos.m_122643_(destination.getDimension(), (BlockPos)destination.getCoordinate());
        return this.destinations.containsKey(key);
    }

    public void assignId(GlobalPos key, int id) {
        this.destinationById.put(id, key);
        this.destinationIdByCoordinate.put(key, id);
    }

    public int getNewId(GlobalPos key) {
        if (this.destinationIdByCoordinate.containsKey(key)) {
            return this.destinationIdByCoordinate.get(key);
        }
        ++this.lastId;
        this.destinationById.put(this.lastId, key);
        this.destinationIdByCoordinate.put(key, this.lastId);
        return this.lastId;
    }

    public Integer getIdForCoordinate(GlobalPos key) {
        return this.destinationIdByCoordinate.get(key);
    }

    public GlobalPos getCoordinateForId(int id) {
        return this.destinationById.get(id);
    }

    public TeleportDestination addDestination(GlobalPos key) {
        if (!this.destinations.containsKey(key)) {
            TeleportDestination teleportDestination = new TeleportDestination(key.m_122646_(), (ResourceKey<Level>)key.m_122640_());
            this.destinations.put(key, teleportDestination);
        }
        return this.destinations.get(key);
    }

    public void removeDestinationsInDimension(ResourceKey<Level> dimension) {
        HashSet<GlobalPos> keysToRemove = new HashSet<GlobalPos>();
        for (Map.Entry<GlobalPos, TeleportDestination> entry : this.destinations.entrySet()) {
            if (!entry.getKey().m_122640_().equals(dimension)) continue;
            keysToRemove.add(entry.getKey());
        }
        for (GlobalPos key : keysToRemove) {
            this.removeDestination(key.m_122646_(), (ResourceKey<Level>)key.m_122640_());
        }
    }

    public void removeDestination(BlockPos coordinate, ResourceKey<Level> dimension) {
        if (coordinate == null) {
            return;
        }
        GlobalPos key = GlobalPos.m_122643_(dimension, (BlockPos)coordinate);
        this.destinations.remove(key);
        Integer id = this.destinationIdByCoordinate.get(key);
        if (id != null) {
            this.destinationById.remove(id);
            this.destinationIdByCoordinate.remove(key);
        }
    }

    public TeleportDestination getDestination(GlobalPos coordinate) {
        return this.destinations.get(coordinate);
    }

    public TeleportDestination getDestination(BlockPos coordinate, ResourceKey<Level> dimension) {
        return this.destinations.get(GlobalPos.m_122643_(dimension, (BlockPos)coordinate));
    }

    private void readDestinationsFromNBT(CompoundTag tagCompound) {
        ListTag lst = tagCompound.m_128437_("destinations", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            TeleportDestination destination = new TeleportDestination(tc);
            GlobalPos gc = GlobalPos.m_122643_(destination.getDimension(), (BlockPos)destination.getCoordinate());
            this.destinations.put(gc, destination);
            if (!tc.m_128441_("id")) continue;
            int id = tc.m_128451_("id");
            this.destinationById.put(id, gc);
            this.destinationIdByCoordinate.put(gc, id);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tagCompound) {
        ListTag destinations = this.destinations.values().stream().map(destination -> {
            CompoundTag tag = destination.writeToTag();
            Integer id = this.destinationIdByCoordinate.get(GlobalPos.m_122643_(destination.getDimension(), (BlockPos)destination.getCoordinate()));
            if (id != null) {
                tag.m_128405_("id", id.intValue());
            }
            return tag;
        }).collect(Collectors.toCollection(ListTag::new));
        tagCompound.m_128365_("destinations", (Tag)destinations);
        tagCompound.m_128405_("lastId", this.lastId);
        return tagCompound;
    }
}

