/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsutility.compat.RFToolsDimCompat;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.DestinationAnalyzerBlock;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterBoosterBlock;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.client.GuiDialingDevice;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.modules.teleporter.data.TransmitterInfo;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DialingDeviceTileEntity
extends GenericTileEntity {
    public static final Key<Integer> PARAM_STATUS = new Key("status", Type.INTEGER);
    public static final int DIAL_RECEIVER_BLOCKED_MASK = 1;
    public static final int DIAL_TRANSMITTER_BLOCKED_MASK = 2;
    public static final int DIAL_INVALID_DESTINATION_MASK = 4;
    public static final int DIAL_DIALER_POWER_LOW_MASK = 8;
    public static final int DIAL_RECEIVER_POWER_LOW_MASK = 16;
    public static final int DIAL_TRANSMITTER_NOACCESS = 32;
    public static final int DIAL_RECEIVER_NOACCESS = 64;
    public static final int DIAL_INTERRUPTED = 128;
    public static final int DIAL_INVALID_SOURCE_MASK = 256;
    public static final int DIAL_DIMENSION_POWER_LOW_MASK = 512;
    public static final int DIAL_INVALID_TRANSMITTER = 1024;
    public static final int DIAL_OK = 0;
    public static final String COMPONENT_NAME = "dialing_device";
    private boolean showOnlyFavorites = false;
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.DIALER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.DIALER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dialing Device").containerSupplier(DefaultContainerProvider.empty(TeleporterModule.CONTAINER_DIALING_DEVICE, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    public static final Key<UUID> PARAM_PLAYER_UUID = new Key("playerUuid", Type.UUID);
    @ServerCommand(type=TeleportDestinationClientInfo.class, serializer=TeleportDestinationClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETRECEIVERS = ListCommand.create((String)"rftoolsutility.dialer.getReceivers", (te, player, params) -> te.searchReceivers((UUID)params.get(PARAM_PLAYER_UUID)), (te, player, params, list) -> {
        GuiDialingDevice.fromServer_receivers = list;
    });
    @ServerCommand(type=TransmitterInfo.class, serializer=TransmitterInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETTRANSMITTERS = ListCommand.create((String)"rftoolsutility.dialer.getTransmitters", (te, player, params) -> te.searchTransmitters(), (te, player, params, list) -> {
        GuiDialingDevice.fromServer_transmitters = list;
    });
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<String> PARAM_DIMENSION = new Key("dimension", Type.STRING);
    public static final Key<BlockPos> PARAM_TRANSMITTER = new Key("transmitter", Type.BLOCKPOS);
    public static final Key<String> PARAM_TRANS_DIMENSION = new Key("transDimension", Type.STRING);
    public static final Key<Boolean> PARAM_FAVORITE = new Key("favorite", Type.BOOLEAN);
    @ServerCommand
    public static final Command<?> CMD_FAVORITE = Command.create((String)"dialer.favorite", (te, p, params) -> {
        String player = (String)params.get(PARAM_PLAYER);
        BlockPos receiver = (BlockPos)params.get(PARAM_POS);
        String dimension = (String)params.get(PARAM_DIMENSION);
        boolean favorite = (Boolean)params.get(PARAM_FAVORITE);
        te.changeFavorite(player, receiver, (ResourceKey<Level>)LevelTools.getId((String)dimension), favorite);
    });
    @ServerCommand
    public static final Command<?> CMD_SHOWFAVORITE = Command.create((String)"dialer.showFavorite", (te, player, params) -> te.setShowOnlyFavorites((Boolean)params.get(PARAM_FAVORITE)));
    @ServerCommand
    public static final ResultCommand<?> CMD_CHECKSTATUS = ResultCommand.create((String)"checkStatus", (te, player, params) -> {
        BlockPos c = (BlockPos)params.get(PARAM_POS);
        String dim = (String)params.get(PARAM_DIMENSION);
        return TypedMap.builder().put(PARAM_STATUS, (Object)te.checkStatus(c, (ResourceKey<Level>)LevelTools.getId((String)dim))).build();
    }, (te, player, params) -> GuiDialingDevice.setReceiverStatus((Integer)params.get(PARAM_STATUS)));
    @ServerCommand
    public static final ResultCommand<?> CMD_DIAL = ResultCommand.create((String)"dial", (te, player, params) -> {
        UUID playerUUID = (UUID)params.get(PARAM_PLAYER_UUID);
        BlockPos transmitter = (BlockPos)params.get(PARAM_TRANSMITTER);
        String transDim = (String)params.get(PARAM_TRANS_DIMENSION);
        BlockPos c = (BlockPos)params.get(PARAM_POS);
        String dim = (String)params.get(PARAM_DIMENSION);
        return TypedMap.builder().put(PARAM_STATUS, (Object)te.dial(playerUUID, transmitter, (ResourceKey<Level>)LevelTools.getId((String)transDim), c, (ResourceKey<Level>)LevelTools.getId((String)dim), false)).build();
    }, (te, player, params) -> GuiDialingDevice.setDialResult((Integer)params.get(PARAM_STATUS)));
    @ServerCommand
    public static final ResultCommand<?> CMD_DIALONCE = ResultCommand.create((String)"dialOnce", (te, player, params) -> {
        UUID playerUUID = (UUID)params.get(PARAM_PLAYER_UUID);
        BlockPos transmitter = (BlockPos)params.get(PARAM_TRANSMITTER);
        String transDim = (String)params.get(PARAM_TRANS_DIMENSION);
        BlockPos c = (BlockPos)params.get(PARAM_POS);
        String dim = (String)params.get(PARAM_DIMENSION);
        return TypedMap.builder().put(PARAM_STATUS, (Object)te.dial(playerUUID, transmitter, (ResourceKey<Level>)LevelTools.getId((String)transDim), c, (ResourceKey<Level>)LevelTools.getId((String)dim), true)).build();
    }, (te, player, params) -> GuiDialingDevice.setDialResult((Integer)params.get(PARAM_STATUS)));

    public DialingDeviceTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TeleporterModule.TYPE_DIALING_DEVICE.get(), pos, state);
    }

    public static String calculateDistance(Level world, TransmitterInfo transmitterInfo, TeleportDestination teleportDestination) {
        if (!world.m_46472_().equals(teleportDestination.getDimension())) {
            return "dimension warp";
        }
        BlockPos c1 = transmitterInfo.getCoordinate();
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3((double)c1.m_123341_(), (double)c1.m_123342_(), (double)c1.m_123343_()).m_82554_(new Vec3((double)c2.m_123341_(), (double)c2.m_123342_(), (double)c2.m_123343_()));
        return Integer.toString((int)dist);
    }

    public static boolean isMatterBoosterAvailable(Level world, BlockPos pos) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!((Object)((Object)((MatterBoosterBlock)((Object)TeleporterModule.MATTER_BOOSTER.get())))).equals(world.m_8055_(pos.m_142300_(facing)).m_60734_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDestinationAnalyzerAvailable(Level world, BlockPos pos) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!((Object)((Object)((DestinationAnalyzerBlock)((Object)TeleporterModule.DESTINATION_ANALYZER.get())))).equals(world.m_8055_(pos.m_142300_(facing)).m_60734_())) continue;
            return true;
        }
        return false;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.energyStorage.setEnergy(tagCompound.m_128454_("Energy"));
        CompoundTag info = tagCompound.m_128469_("Info");
        this.showOnlyFavorites = info.m_128471_("showFav");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        this.getOrCreateInfo(tagCompound).m_128379_("showFav", this.showOnlyFavorites);
        tagCompound.m_128356_("Energy", this.energyStorage.getEnergy());
    }

    private List<TeleportDestinationClientInfo> searchReceivers(UUID player) {
        TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
        return new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(this.f_58857_, player));
    }

    public List<TransmitterInfo> searchTransmitters() {
        int x = this.m_58899_().m_123341_();
        int y = this.m_58899_().m_123342_();
        int z = this.m_58899_().m_123343_();
        int hrange = (Integer)TeleportConfiguration.horizontalDialerRange.get();
        int vrange = (Integer)TeleportConfiguration.verticalDialerRange.get();
        ArrayList<TransmitterInfo> transmitters = new ArrayList<TransmitterInfo>();
        for (int dy = -vrange; dy <= vrange; ++dy) {
            int yy = y + dy;
            if (yy < this.f_58857_.m_141937_() || yy >= this.f_58857_.m_151558_()) continue;
            for (int dz = -hrange; dz <= hrange; ++dz) {
                int zz = z + dz;
                for (int dx = -hrange; dx <= hrange; ++dx) {
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos c = new BlockPos(xx, yy, zz);
                    BlockState state = this.f_58857_.m_8055_(c);
                    BlockEntity tileEntity = this.f_58857_.m_7702_(c);
                    if (!(tileEntity instanceof MatterTransmitterTileEntity)) continue;
                    MatterTransmitterTileEntity transmitter = (MatterTransmitterTileEntity)tileEntity;
                    transmitters.add(new TransmitterInfo(c, transmitter.getName(), transmitter.getTeleportDestination()));
                }
            }
        }
        return transmitters;
    }

    private void changeFavorite(String playerName, BlockPos receiver, ResourceKey<Level> dimension, boolean favorite) {
        List list = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        for (ServerPlayer entity : list) {
            if (!playerName.equals(entity.m_7755_().getString())) continue;
            PlayerExtendedProperties.getFavoriteDestinations((Player)entity).ifPresent(h -> h.setDestinationFavorite(GlobalPos.m_122643_((ResourceKey)dimension, (BlockPos)receiver), favorite));
            return;
        }
    }

    private int dial(UUID player, BlockPos transmitter, ResourceKey<Level> transDim, BlockPos coordinate, ResourceKey<Level> dimension, boolean once) {
        return TeleportationTools.dial(this.f_58857_, this, player, transmitter, transDim, coordinate, dimension, once);
    }

    private int checkStatus(BlockPos c, ResourceKey<Level> dim) {
        int s;
        int defaultCost = (Integer)TeleportConfiguration.rfPerCheck.get();
        int cost = this.infusableHandler.map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
        if (this.energyStorage.getEnergy() < (long)cost) {
            s = 8;
        } else {
            this.energyStorage.consumeEnergy((long)cost);
            s = 0;
        }
        if (s != 0) {
            return s;
        }
        ServerLevel w = LevelTools.getLevel(dim);
        if (w == null) {
            TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
            destinations.cleanupInvalid();
            return 4;
        }
        BlockEntity tileEntity = w.m_7702_(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
            destinations.cleanupInvalid();
            return 4;
        }
        MatterReceiverTileEntity matterReceiver = (MatterReceiverTileEntity)tileEntity;
        int powerPercentage = RFToolsDimCompat.getPowerPercentage(this.f_58857_, dim.m_135782_());
        System.out.println("powerPercentage = " + powerPercentage);
        if (powerPercentage >= 0 && powerPercentage < (Integer)TeleportConfiguration.DIMENSION_WARN_PERCENTAGE.get()) {
            return 512;
        }
        return matterReceiver.checkStatus();
    }
}

