/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.xp;

import cofh.lib.util.IResourceStorage;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.xp.IXpStorage;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.INBTSerializable;

public class XpStorage
implements IXpStorage,
IResourceStorage,
INBTSerializable<CompoundTag> {
    protected final int baseCapacity;
    protected BooleanSupplier creative = Constants.FALSE;
    protected int xp;
    protected int capacity;

    public XpStorage(int capacity) {
        this(capacity, 0);
    }

    public XpStorage(int capacity, int xp) {
        this.baseCapacity = capacity;
        this.capacity = capacity;
        this.xp = Math.max(0, Math.min(capacity, xp));
    }

    public XpStorage applyModifiers(float storageMod) {
        this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        return this;
    }

    public XpStorage setCapacity(int capacity) {
        this.capacity = MathHelper.clamp(capacity, 0, Integer.MAX_VALUE);
        this.xp = Math.max(0, Math.min(capacity, this.xp));
        return this;
    }

    public XpStorage setCreative(BooleanSupplier creative) {
        this.creative = creative;
        if (this.isCreative()) {
            this.xp = this.getCapacity();
        }
        return this;
    }

    public void setXpStored(int amount) {
        this.xp = amount;
        this.xp = Math.max(0, Math.min(this.capacity, this.xp));
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.setCapacity(buffer.readInt());
        this.setXpStored(buffer.readInt());
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.getMaxXpStored());
        buffer.writeInt(this.getXpStored());
    }

    public XpStorage read(CompoundTag nbt) {
        this.xp = nbt.m_128451_("Xp");
        if (this.xp > this.capacity) {
            this.xp = this.capacity;
        }
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.capacity <= 0) {
            return nbt;
        }
        nbt.m_128405_("Xp", this.xp);
        return nbt;
    }

    public CompoundTag writeWithParams(CompoundTag nbt) {
        if (this.capacity <= 0) {
            return nbt;
        }
        nbt.m_128405_("Xp", this.xp);
        nbt.m_128405_("XpMax", this.baseCapacity);
        return nbt;
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    @Override
    public int receiveXp(int maxReceive, boolean simulate) {
        int xpReceived = Math.min(this.capacity - this.xp, maxReceive);
        if (!simulate) {
            this.xp += xpReceived;
        }
        return xpReceived;
    }

    @Override
    public int extractXp(int maxExtract, boolean simulate) {
        int xpExtracted = Math.min(this.xp, maxExtract);
        if (!simulate) {
            this.xp -= xpExtracted;
        }
        return xpExtracted;
    }

    @Override
    public int getXpStored() {
        return this.xp;
    }

    @Override
    public int getMaxXpStored() {
        return this.capacity;
    }

    @Override
    public boolean clear() {
        if (this.isEmpty()) {
            return false;
        }
        this.xp = 0;
        return true;
    }

    @Override
    public void modify(int amount) {
        this.xp += amount;
        if (this.xp > this.capacity) {
            this.xp = this.capacity;
        } else if (this.xp < 0) {
            this.xp = 0;
        }
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.xp <= 0 && this.capacity > 0;
    }

    @Override
    public int getCapacity() {
        return this.getMaxXpStored();
    }

    @Override
    public int getStored() {
        return this.getXpStored();
    }

    @Override
    public String getUnit() {
        return "XP";
    }
}

