/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.constants.Constants;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public final class StringHelper {
    public static final DecimalFormat DF0 = new DecimalFormat("#");
    public static final DecimalFormat DF2 = new DecimalFormat("#.##");

    private StringHelper() {
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public static String localize(String key) {
        return I18n.m_118938_((String)key, (Object[])new Object[0]);
    }

    public static String localize(String key, Object ... format) {
        return I18n.m_118938_((String)key, (Object[])format);
    }

    public static boolean canLocalize(String key) {
        return I18n.m_118936_((String)key);
    }

    public static String format(long number) {
        return StringUtils.normalizeSpace((String)NumberFormat.getInstance().format(number));
    }

    public static MutableComponent getFluidName(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        MutableComponent name = fluid.getAttributes().getDisplayName(stack).m_6881_();
        switch (fluid.getAttributes().getRarity(stack)) {
            case UNCOMMON: {
                name.m_130940_(ChatFormatting.YELLOW);
                break;
            }
            case RARE: {
                name.m_130940_(ChatFormatting.AQUA);
                break;
            }
            case EPIC: {
                name.m_130940_(ChatFormatting.LIGHT_PURPLE);
            }
        }
        return name;
    }

    public static MutableComponent getItemName(ItemStack stack) {
        Item item = stack.m_41720_();
        MutableComponent name = item.m_7626_(stack).m_6881_();
        switch (item.m_41460_(stack)) {
            case UNCOMMON: {
                name.m_130940_(ChatFormatting.YELLOW);
                break;
            }
            case RARE: {
                name.m_130940_(ChatFormatting.AQUA);
                break;
            }
            case EPIC: {
                name.m_130940_(ChatFormatting.LIGHT_PURPLE);
            }
        }
        return name;
    }

    public static String getScaledNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 100000000L + number % 100000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 100000L + number % 100000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 100L + number % 100L / 10L + "k";
        }
        return String.valueOf(number);
    }

    public static String toJSON(Component chatComponent) {
        return Component.Serializer.m_130703_((Component)chatComponent);
    }

    public static MutableComponent fromJSON(String string) {
        return Component.Serializer.m_130714_((String)string);
    }

    public static MutableComponent getEmptyLine() {
        return new TextComponent("");
    }

    public static MutableComponent getTextComponent(String key) {
        return StringHelper.canLocalize(key) ? new TranslatableComponent(key) : new TextComponent(key);
    }

    public static MutableComponent getInfoTextComponent(String key) {
        return StringHelper.getTextComponent(key).m_130940_(ChatFormatting.GOLD);
    }

    public static MutableComponent getKeywordTextComponent(String key) {
        return StringHelper.getTextComponent(key).m_130948_(Constants.INVIS_STYLE);
    }

    public static String[] decompose(String resourceLoc, char delimiter) {
        return StringHelper.decompose("minecraft", resourceLoc, delimiter);
    }

    public static String[] decompose(String modid, String resourceLoc, char delimiter) {
        String[] decomposed = new String[]{modid, resourceLoc};
        int delIndex = resourceLoc.indexOf(delimiter);
        if (delIndex >= 0) {
            decomposed[1] = resourceLoc.substring(delIndex + 1);
            if (delIndex >= 1) {
                decomposed[0] = resourceLoc.substring(0, delIndex);
            }
        }
        return decomposed;
    }

    public static String namespace(String resourceLoc) {
        return StringHelper.decompose(resourceLoc, ':')[0];
    }

    public static String path(String resourceLoc) {
        return StringHelper.decompose(resourceLoc, ':')[1];
    }
}

