/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.util.RayTracer;
import cofh.lib.util.Utils;
import cofh.lib.util.references.EnsorcReferences;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class AreaEffectHelper {
    private AreaEffectHelper() {
    }

    public static boolean validAreaEffectItem(ItemStack stack) {
        return stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).isPresent() || stack.m_41720_() instanceof DiggerItem;
    }

    public static boolean validAreaEffectMiningItem(ItemStack stack) {
        return stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).isPresent() || stack.m_41720_() instanceof DiggerItem;
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocks(ItemStack stack, BlockPos pos, Player player) {
        int encExcavating = Utils.getItemEnchantmentLevel(EnsorcReferences.EXCAVATING, stack);
        if (encExcavating > 0) {
            return AreaEffectHelper.getBreakableBlocksRadius(stack, pos, player, encExcavating);
        }
        int encTilling = Utils.getItemEnchantmentLevel(EnsorcReferences.TILLING, stack);
        if (encTilling > 0) {
            return AreaEffectHelper.getTillableBlocksRadius(stack, pos, player, encTilling);
        }
        int encFurrowing = Utils.getItemEnchantmentLevel(EnsorcReferences.FURROWING, stack);
        if (encFurrowing > 0) {
            return AreaEffectHelper.getTillableBlocksLine(stack, pos, player, encFurrowing * 2);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockPos> getBucketableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.SOURCE_ONLY);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || radius <= 0) {
            return ImmutableList.of();
        }
        int yMin = -1;
        int yMax = 2 * radius - 1;
        List area = switch (traceResult.m_82434_()) {
            case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.isBucketable(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, yMin, 0), (BlockPos)pos.m_142082_(radius, yMax, 0)).filter(blockPos -> AreaEffectHelper.isBucketable(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> BlockPos.m_121990_((BlockPos)pos.m_142082_(0, yMin, -radius), (BlockPos)pos.m_142082_(0, yMax, radius)).filter(blockPos -> AreaEffectHelper.isBucketable(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        };
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0) {
            return ImmutableList.of();
        }
        int yMin = -1;
        int yMax = 2 * radius - 1;
        List area = switch (traceResult.m_82434_()) {
            case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, yMin, 0), (BlockPos)pos.m_142082_(radius, yMax, 0)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> BlockPos.m_121990_((BlockPos)pos.m_142082_(0, yMin, -radius), (BlockPos)pos.m_142082_(0, yMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        };
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableBlocksDepth(ItemStack stack, BlockPos pos, Player player, int radius, int depth) {
        List area;
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && depth <= 0) {
            return ImmutableList.of();
        }
        int dMin = depth;
        int dMax = 0;
        int yMin = -1;
        int yMax = 2 * radius - 1;
        switch (traceResult.m_82434_()) {
            case DOWN: {
                dMin = 0;
                dMax = depth;
            }
            case UP: {
                area = BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, -dMin, -radius), (BlockPos)pos.m_142082_(radius, dMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
                break;
            }
            case NORTH: {
                dMin = 0;
                dMax = depth;
            }
            case SOUTH: {
                area = BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, yMin, -dMin), (BlockPos)pos.m_142082_(radius, yMax, dMax)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
                break;
            }
            case WEST: {
                dMin = 0;
                dMax = depth;
            }
            default: {
                area = BlockPos.m_121990_((BlockPos)pos.m_142082_(-dMin, yMin, -radius), (BlockPos)pos.m_142082_(dMax, yMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            }
        }
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableBlocksLine(ItemStack stack, BlockPos pos, Player player, int length) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || length <= 0) {
            return ImmutableList.of();
        }
        switch (player.m_6350_()) {
            case SOUTH: {
                BlockPos query;
                for (int k = z + 1; k < z + length + 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); ++k) {
                    area.add(query);
                }
                break;
            }
            case WEST: {
                BlockPos query;
                for (int i = x - 1; i > x - length - 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); --i) {
                    area.add(query);
                }
                break;
            }
            case NORTH: {
                BlockPos query;
                for (int k = z - 1; k > z - length - 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); --k) {
                    area.add(query);
                }
                break;
            }
            case EAST: {
                BlockPos query;
                for (int i = x + 1; i < x + length + 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); ++i) {
                    area.add(query);
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getPlaceableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0) {
            return ImmutableList.of();
        }
        int yMin = -1;
        int yMax = 2 * radius - 1;
        return ImmutableList.copyOf(switch (traceResult.m_82434_()) {
            case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, yMin, 0), (BlockPos)pos.m_142082_(radius, yMax, 0)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> BlockPos.m_121990_((BlockPos)pos.m_142082_(0, yMin, -radius), (BlockPos)pos.m_142082_(0, yMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        });
    }

    public static ImmutableList<BlockPos> getTillableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        boolean weeding = Utils.getItemEnchantmentLevel(EnsorcReferences.WEEDING, stack) > 0;
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || traceResult.m_82434_() == Direction.DOWN || player.m_36341_() || !AreaEffectHelper.canHoeAffect(world, pos, weeding) || radius <= 0) {
            return ImmutableList.of();
        }
        List area = BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::m_7949_).collect(Collectors.toList());
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getTillableBlocksLine(ItemStack stack, BlockPos pos, Player player, int length) {
        boolean weeding;
        Level world = player.m_20193_();
        boolean bl = weeding = Utils.getItemEnchantmentLevel(EnsorcReferences.WEEDING, stack) > 0;
        if (player.m_36341_() || !AreaEffectHelper.canHoeAffect(world, pos, weeding) || length <= 0) {
            return ImmutableList.of();
        }
        Object area = switch (player.m_6350_()) {
            case Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_142082_(0, 0, 1), (BlockPos)pos.m_142082_(0, 0, length + 1)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.WEST -> BlockPos.m_121990_((BlockPos)pos.m_142082_(-1, 0, 0), (BlockPos)pos.m_142082_(-(length + 1), 0, 0)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH -> BlockPos.m_121990_((BlockPos)pos.m_142082_(0, 0, -1), (BlockPos)pos.m_142082_(0, 0, -(length + 1))).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.EAST -> BlockPos.m_121990_((BlockPos)pos.m_142082_(1, 0, 0), (BlockPos)pos.m_142082_(length + 1, 0, 0)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> ImmutableList.of();
        };
        area.remove(pos);
        return ImmutableList.copyOf((Collection)area);
    }

    public static ImmutableList<BlockPos> getBlocksCentered(ItemStack stack, BlockPos pos, Player player, int radius, int height) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        if (player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && height <= 0) {
            return ImmutableList.of();
        }
        List area = BlockPos.m_121990_((BlockPos)pos.m_142082_(-radius, -height, -radius), (BlockPos)pos.m_142082_(radius, height, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    private static boolean canToolAffect(Item toolItem, ItemStack toolStack, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60800_((BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        return toolItem.isCorrectToolForDrops(toolStack, state) || !state.m_60834_() && toolItem.m_8102_(toolStack, state) > 1.0f;
    }

    private static boolean canHoeAffect(Level world, BlockPos pos, boolean weeding) {
        return false;
    }

    private static boolean isBucketable(Item toolItem, ItemStack toolStack, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof BucketPickup;
    }
}

