/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

public interface IRedstoneControllable {
    public int getPower();

    public int getThreshold();

    public ControlMode getMode();

    public void setPower(int var1);

    public void setControl(int var1, ControlMode var2);

    default public boolean getState() {
        return this.getMode().matches(this.getPower(), this.getThreshold());
    }

    public boolean isControllable();

    public static enum ControlMode {
        DISABLED,
        LOW,
        HIGH,
        EQUAL,
        UNDER,
        UNDER_INC,
        OVER,
        OVER_INC;

        public static final ControlMode[] VALUES;

        boolean matches(int power, int threshold) {
            switch (this) {
                case LOW: {
                    return power <= 0;
                }
                case HIGH: {
                    return power > 0;
                }
                case EQUAL: {
                    return power == threshold;
                }
                case UNDER: {
                    return power < threshold;
                }
                case OVER: {
                    return power > threshold;
                }
                case UNDER_INC: {
                    return power <= threshold;
                }
                case OVER_INC: {
                    return power >= threshold;
                }
            }
            return true;
        }

        static {
            VALUES = ControlMode.values();
        }
    }
}

