/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.IInventoryCallback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SimpleItemHandler
implements IItemHandler {
    @Nullable
    protected IInventoryCallback callback;
    protected List<ItemStorageCoFH> slots;

    public SimpleItemHandler(@Nonnull List<ItemStorageCoFH> slots) {
        this(null, slots);
    }

    public SimpleItemHandler(@Nullable IInventoryCallback callback) {
        this.callback = callback;
        this.slots = new ArrayList<ItemStorageCoFH>();
    }

    public SimpleItemHandler(@Nullable IInventoryCallback callback, @Nonnull List<ItemStorageCoFH> slots) {
        this.callback = callback;
        this.slots = new ArrayList<ItemStorageCoFH>(slots);
    }

    public boolean isEmpty() {
        for (ItemStorageCoFH slot : this.slots) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (ItemStorageCoFH slot : this.slots) {
            if (slot.isFull()) continue;
            return false;
        }
        return true;
    }

    public void onInventoryChange(int slot) {
        if (this.callback == null) {
            return;
        }
        this.callback.onInventoryChanged(slot);
    }

    public int getSlots() {
        return this.slots.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            return ItemStack.f_41583_;
        }
        return this.slots.get(slot).getItemStack();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= this.getSlots()) {
            return stack;
        }
        ItemStack ret = this.slots.get(slot).insertItem(slot, stack, simulate);
        if (!simulate) {
            this.onInventoryChange(slot);
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot >= this.getSlots()) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = this.slots.get(slot).extractItem(slot, amount, simulate);
        if (!simulate) {
            this.onInventoryChange(slot);
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            return 0;
        }
        return this.slots.get(slot).getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot < 0 || slot >= this.getSlots()) {
            return false;
        }
        return this.slots.get(slot).isItemValid(stack);
    }
}

