/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.config;

import cofh.lib.config.IBaseConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigManager {
    protected List<IBaseConfig> commonSubConfigs = new ArrayList<IBaseConfig>();
    protected List<IBaseConfig> serverSubConfigs = new ArrayList<IBaseConfig>();
    protected List<IBaseConfig> clientSubConfigs = new ArrayList<IBaseConfig>();
    protected boolean commonInit = false;
    protected boolean clientInit = false;
    protected boolean serverInit = false;
    protected final ForgeConfigSpec.Builder commonConfig = new ForgeConfigSpec.Builder();
    protected ForgeConfigSpec commonSpec;
    protected final ForgeConfigSpec.Builder clientConfig = new ForgeConfigSpec.Builder();
    protected ForgeConfigSpec clientSpec;
    protected final ForgeConfigSpec.Builder serverConfig = new ForgeConfigSpec.Builder();
    protected ForgeConfigSpec serverSpec;

    public ConfigManager register(IEventBus bus) {
        bus.register((Object)this);
        return this;
    }

    public ConfigManager addCommonConfig(IBaseConfig config) {
        this.commonSubConfigs.add(config);
        return this;
    }

    public ConfigManager addClientConfig(IBaseConfig config) {
        this.clientSubConfigs.add(config);
        return this;
    }

    public ConfigManager addServerConfig(IBaseConfig config) {
        this.serverSubConfigs.add(config);
        return this;
    }

    public void setupCommon() {
        if (!this.commonInit) {
            this.genCommonConfig();
            this.commonSpec = this.commonConfig.build();
            this.refreshCommonConfig();
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.commonSpec);
            this.commonInit = true;
            String configName = String.format(Locale.ROOT, "%s-%s.toml", ModLoadingContext.get().getActiveContainer().getModId(), ModConfig.Type.COMMON.extension());
            ConfigManager.loadConfig(this.commonSpec, FMLPaths.CONFIGDIR.get().resolve(configName));
        }
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public void setupClient() {
        if (!this.clientInit) {
            this.genClientConfig();
            this.clientSpec = this.clientConfig.build();
            this.refreshClientConfig();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
            this.clientInit = true;
        }
    }

    public void setupServer() {
        if (!this.serverInit) {
            this.genServerConfig();
            this.serverSpec = this.serverConfig.build();
            this.refreshServerConfig();
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)this.serverSpec);
            this.serverInit = true;
        }
    }

    public boolean isClientInit() {
        return this.clientInit;
    }

    public boolean isServerInit() {
        return this.serverInit;
    }

    public ForgeConfigSpec getServerSpec() {
        return this.serverSpec;
    }

    public ForgeConfigSpec getClientSpec() {
        return this.clientSpec;
    }

    protected void genCommonConfig() {
        for (IBaseConfig cfg : this.commonSubConfigs) {
            cfg.apply(this.commonConfig);
        }
    }

    protected void genServerConfig() {
        for (IBaseConfig cfg : this.serverSubConfigs) {
            cfg.apply(this.serverConfig);
        }
    }

    protected void genClientConfig() {
        for (IBaseConfig cfg : this.clientSubConfigs) {
            cfg.apply(this.clientConfig);
        }
    }

    protected void refreshCommonConfig() {
        this.commonSubConfigs.forEach(IBaseConfig::refresh);
    }

    protected void refreshServerConfig() {
        this.serverSubConfigs.forEach(IBaseConfig::refresh);
    }

    protected void refreshClientConfig() {
        this.clientSubConfigs.forEach(IBaseConfig::refresh);
    }

    @SubscribeEvent
    public void configRefresh(ModConfigEvent event) {
        switch (event.getConfig().getType()) {
            case COMMON: {
                this.refreshCommonConfig();
                break;
            }
            case CLIENT: {
                this.refreshClientConfig();
                break;
            }
            case SERVER: {
                this.refreshServerConfig();
            }
        }
    }
}

