/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.rails;

import cofh.lib.block.IDismantleable;
import cofh.lib.block.IWrenchable;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PoweredRailBlockCoFH
extends PoweredRailBlock
implements IDismantleable,
IWrenchable {
    protected float maxSpeed = 0.4f;

    public PoweredRailBlockCoFH(BlockBehaviour.Properties builder) {
        this(builder, false);
    }

    public PoweredRailBlockCoFH(BlockBehaviour.Properties builder, boolean isActivator) {
        super(builder, isActivator);
    }

    public PoweredRailBlockCoFH speed(float maxSpeed) {
        this.maxSpeed = MathHelper.clamp(maxSpeed, 0.0f, 1.0f);
        return this;
    }

    public float getRailMaxSpeed(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        return this.maxSpeed;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (Utils.isWrench(player.m_21120_(handIn))) {
            if (player.m_36341_()) {
                if (this.canDismantle(worldIn, pos, state, player)) {
                    this.dismantleBlock(worldIn, pos, state, (HitResult)hit, player, false);
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockState rotState = this.rotate(state, (LevelAccessor)worldIn, pos, Rotation.CLOCKWISE_90);
                if (rotState != state) {
                    worldIn.m_46597_(pos, rotState);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

