/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl;

import cofh.lib.util.constants.Constants;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class SoilBlock
extends Block {
    protected static final VoxelShape SHAPE_TILLED = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected Supplier<Block> otherBlock = () -> Blocks.f_50493_;

    public SoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)Constants.CHARGED, (Comparable)Integer.valueOf(0)));
    }

    public SoilBlock otherBlock(Supplier<Block> dirt) {
        this.otherBlock = dirt;
        return this;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{Constants.CHARGED});
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = worldIn.m_8055_(abovePos);
        if (aboveState.m_60734_() instanceof IPlantable && aboveState.m_60823_()) {
            int charge = (Integer)state.m_61143_((Property)Constants.CHARGED);
            int boost = 1 + charge;
            for (int i = 0; i < boost; ++i) {
                aboveState.m_60735_(worldIn, abovePos, rand);
            }
            if (rand.nextInt(boost) > 0) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)Constants.CHARGED, (Comparable)Integer.valueOf(Math.max(0, charge - 1))), 2);
            }
        }
    }

    public static void charge(BlockState state, Level worldIn, BlockPos pos) {
        int charge = (Integer)state.m_61143_((Property)Constants.CHARGED);
        if (charge < 4) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)Constants.CHARGED, (Comparable)Integer.valueOf(charge + 1)), 2);
        } else if (worldIn instanceof ServerLevel) {
            state.m_60734_().m_7458_(state, (ServerLevel)worldIn, pos, worldIn.f_46441_);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.canSustainPlant(state, world, pos, facing, plantable, false);
    }

    protected boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable, boolean tilled) {
        if (plantable.getPlant(world, pos.m_142300_(facing)).m_60734_() instanceof AttachedStemBlock) {
            return true;
        }
        PlantType type = plantable.getPlantType(world, pos.m_7494_());
        if (type == PlantType.CROP) {
            return tilled;
        }
        if (type == PlantType.CAVE || type == PlantType.DESERT || type == PlantType.PLAINS || type == Constants.FUNGUS) {
            return !tilled;
        }
        if (type == PlantType.BEACH) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos qPos = pos.m_142300_(direction);
                if (!world.m_6425_(qPos).m_205070_(FluidTags.f_13131_) && world.m_8055_(qPos).m_60734_() != Blocks.f_50449_) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        BlockState toolModifiedState = this.getToolModifiedState(state, context.m_43725_(), context.m_8083_(), context.m_43723_(), context.m_43722_(), toolAction);
        if (ToolActions.HOE_TILL == toolAction && context.m_43722_().canPerformAction(ToolActions.HOE_TILL) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            return this.otherBlock.get().m_49966_();
        }
        return toolModifiedState;
    }
}

