/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.lib.util.helpers.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class RenderHelper {
    public static final float RENDER_OFFSET = 0.001953125f;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_SGA = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static int vertexColorIndex;

    private RenderHelper() {
    }

    public static TextureManager engine() {
        return Minecraft.m_91087_().m_91097_();
    }

    public static TextureAtlas textureMap() {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
    }

    public static Tesselator tesselator() {
        return Tesselator.m_85913_();
    }

    public static ItemRenderer renderItem() {
        return Minecraft.m_91087_().m_91291_();
    }

    public static BlockRenderDispatcher renderBlock() {
        return Minecraft.m_91087_().m_91289_();
    }

    public static void setBlockTextureSheet() {
        RenderHelper.setShaderTexture0(MC_BLOCK_SHEET);
    }

    public static void setDefaultFontTextureSheet() {
        RenderHelper.setShaderTexture0(MC_FONT_DEFAULT);
    }

    public static void setSGAFontTextureSheet() {
        RenderHelper.setShaderTexture0(MC_FONT_SGA);
    }

    public static void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        RenderHelper.setPosTexShader();
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setSahderColorFromInt(color);
        RenderHelper.drawTiledTexture(x, y, RenderHelper.getTexture(fluid.getFluid().getAttributes().getStillTexture(fluid)), width, height);
    }

    public static int getFluidColor(FluidStack fluid) {
        return fluid.getFluid().getAttributes().getColor(fluid);
    }

    public static void drawIcon(TextureAtlasSprite icon, double z) {
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, 16.0, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_5483_(16.0, 16.0, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_5483_(16.0, 0.0, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_5483_(0.0, 0.0, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawIcon(double x, double y, double z, TextureAtlasSprite icon, int width, int height) {
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(x, y + (double)height, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_5483_(x + (double)width, y + (double)height, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_5483_(x + (double)width, y, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_5483_(x, y, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModalRectFromSprite(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        RenderHelper.resetShaderColor();
    }

    public static void drawScaledTexturedModalRectFromSprite(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float u = minU + (maxU - minU) * (float)width / 16.0f;
        float v = minV + (maxV - minV) * (float)height / 16.0f;
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(minU, v).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(u, v).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(u, minV).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(minU, minV).m_5752_();
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawFluid(PoseStack matrixStack, int x, int y, FluidStack fluid, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        RenderHelper.setPosTexShader();
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setSahderColorFromInt(color);
        RenderHelper.drawTiledTexture(matrixStack, x, y, RenderHelper.getTexture(fluid.getFluid().getAttributes().getStillTexture(fluid)), width, height);
    }

    public static void drawIcon(PoseStack matrixStack, TextureAtlasSprite icon, float z) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, 0.0f, 16.0f, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_85982_(matrix, 16.0f, 16.0f, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_85982_(matrix, 16.0f, 0.0f, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_85982_(matrix, 0.0f, 0.0f, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawIcon(PoseStack matrixStack, float x, float y, float z, TextureAtlasSprite icon, int width, int height) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, x, y + (float)height, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_85982_(matrix, x + (float)width, y + (float)height, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_85982_(matrix, x + (float)width, y, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_85982_(matrix, x, y, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawTiledTexture(PoseStack matrixStack, int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModalRectFromSprite(matrixStack, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        RenderHelper.resetShaderColor();
    }

    public static void drawScaledTexturedModalRectFromSprite(PoseStack matrixStack, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float u = minU + (maxU - minU) * (float)width / 16.0f;
        float v = minV + (maxV - minV) * (float)height / 16.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(minU, v).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(u, v).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(u, minV).m_5752_();
        buffer.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_5752_();
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawStencil(PoseStack matrixStack, int xStart, int yStart, int xEnd, int yEnd, int flag) {
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)flag);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.m_69458_((boolean)false);
        GL11.glClearStencil((int)0);
        RenderSystem.m_69421_((int)1024, (boolean)false);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_85982_(matrix, (float)xStart, (float)yEnd, 0.0f).m_5752_();
        buffer.m_85982_(matrix, (float)xEnd, (float)yEnd, 0.0f).m_5752_();
        buffer.m_85982_(matrix, (float)xEnd, (float)yStart, 0.0f).m_5752_();
        buffer.m_85982_(matrix, (float)xStart, (float)yStart, 0.0f).m_5752_();
        RenderHelper.tesselator().m_85914_();
        RenderSystem.m_69493_();
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69458_((boolean)true);
    }

    public static TextureAtlasSprite getTexture(String location) {
        return RenderHelper.textureMap().m_118316_(new ResourceLocation(location));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return RenderHelper.textureMap().m_118316_(location);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid) {
        return RenderHelper.getTexture(fluid.getAttributes().getStillTexture());
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        return RenderHelper.getTexture(fluid.getFluid().getAttributes().getStillTexture(fluid));
    }

    public static boolean textureExists(String location) {
        return RenderHelper.textureExists(new ResourceLocation(location));
    }

    public static boolean textureExists(ResourceLocation location) {
        return !(RenderHelper.getTexture(location) instanceof MissingTextureAtlasSprite);
    }

    public static BakedQuad mulColor(BakedQuad quad, int color) {
        VertexFormat from = DefaultVertexFormat.f_85811_;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int[] packedData = (int[])quad.m_111303_().clone();
        float[] data = new float[4];
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])packedData, (float[])data, (VertexFormat)from, (int)v, (int)vertexColorIndex);
            data[0] = MathHelper.clamp(data[0] * r, 0.0f, 1.0f);
            data[1] = MathHelper.clamp(data[1] * g, 0.0f, 1.0f);
            data[2] = MathHelper.clamp(data[2] * b, 0.0f, 1.0f);
            LightUtil.pack((float[])data, (int[])packedData, (VertexFormat)from, (int)v, (int)vertexColorIndex);
        }
        return new BakedQuad(packedData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static void setSahderColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void setPosTexShader() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
    }

    public static void resetShaderColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setShaderTexture0(ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void renderItemOnBlockSide(PoseStack poseStackIn, ItemStack stack, Direction side, BlockPos pos) {
        if (stack.m_41619_() || side.m_122434_() == Direction.Axis.Y) {
            return;
        }
        poseStackIn.m_85836_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch (side) {
            case NORTH: {
                poseStackIn.m_85837_((double)x + 0.75, (double)y + 0.84375, (double)((float)z + 0.28320312f));
                break;
            }
            case SOUTH: {
                poseStackIn.m_85837_((double)x + 0.25, (double)y + 0.84375, (double)((float)(z + 1) - 0.28320312f));
                poseStackIn.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                break;
            }
            case WEST: {
                poseStackIn.m_85837_((double)((float)x + 0.28320312f), (double)y + 0.84375, (double)z + 0.25);
                poseStackIn.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                break;
            }
            case EAST: {
                poseStackIn.m_85837_((double)((float)(x + 1) - 0.28320312f), (double)y + 0.84375, (double)z + 0.75);
                poseStackIn.m_85845_(new Quaternion(0.0f, 270.0f, 0.0f, true));
                break;
            }
        }
        poseStackIn.m_85841_(0.03125f, 0.03125f, -0.001953125f);
        poseStackIn.m_85845_(new Quaternion(0.0f, 0.0f, 180.0f, true));
        poseStackIn.m_85849_();
    }

    public static void renderCuboid(AABB aabb, PoseStack poseStack, VertexConsumer buffer, int light, float r, float g, float b, float a, TextureAtlasSprite icon) {
        Matrix4f mat4 = poseStack.m_85850_().m_85861_();
        Matrix3f mat3 = poseStack.m_85850_().m_85864_();
        float u0 = icon.m_118409_();
        float u1 = icon.m_118410_();
        float v0 = icon.m_118411_();
        float v1 = icon.m_118412_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void renderRectPrism(VertexConsumer builder, PoseStack stack, int packedLightIn, Vector3f start, Vector3f end, Vector3f perp) {
        PoseStack.Pose stackEntry = stack.m_85850_();
        Matrix4f pose = stackEntry.m_85861_();
        Matrix3f normal = stackEntry.m_85864_();
        float sx = start.m_122239_();
        float sy = start.m_122260_();
        float sz = start.m_122269_();
        float ex = end.m_122239_();
        float ey = end.m_122260_();
        float ez = end.m_122269_();
        Vector3f diff = end.m_122281_();
        diff.m_122267_(start);
        diff.m_122278_();
        float p1x = perp.m_122239_();
        float p1y = perp.m_122260_();
        float p1z = perp.m_122269_();
        perp.m_122251_(diff.m_122240_(90.0f));
        float p2x = perp.m_122239_();
        float p2y = perp.m_122260_();
        float p2z = perp.m_122269_();
        builder.m_85982_(pose, sx + p1x + p2x, sy + p1y + p2y, sz + p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex + p1x + p2x, ey + p1y + p2y, ez + p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex - p1x + p2x, ey - p1y + p2y, ez - p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx - p1x + p2x, sy - p1y + p2y, sz - p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx + p1x - p2x, sy + p1y - p2y, sz + p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex + p1x - p2x, ey + p1y - p2y, ez + p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex - p1x - p2x, ey - p1y - p2y, ez - p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx - p1x - p2x, sy - p1y - p2y, sz - p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx + p1x + p2x, sy + p1y + p2y, sz + p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex + p1x + p2x, ey + p1y + p2y, ez + p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex + p1x - p2x, ey + p1y - p2y, ez + p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx + p1x - p2x, sy + p1y - p2y, sz + p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx - p1x + p2x, sy - p1y + p2y, sz - p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex - p1x + p2x, ey - p1y + p2y, ez - p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex - p1x - p2x, ey - p1y - p2y, ez - p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx - p1x - p2x, sy - p1y - p2y, sz - p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx + p1x + p2x, sy + p1y + p2y, sz + p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx - p1x + p2x, sy - p1y + p2y, sz - p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx - p1x - p2x, sy - p1y - p2y, sz - p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, sx + p1x - p2x, sy + p1y - p2y, sz + p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex + p1x + p2x, ey + p1y + p2y, ez + p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex - p1x + p2x, ey - p1y + p2y, ez - p1z + p2z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex - p1x - p2x, ey - p1y - p2y, ez - p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, ex + p1x - p2x, ey + p1y - p2y, ez + p1z - p2z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderRectPrism(VertexConsumer builder, PoseStack stack, int packedLightIn, Vector3f start, Vector3f end, float radius) {
        Vector3f diff = end.m_122281_();
        diff.m_122267_(start);
        Vector3f perp = (double)diff.m_122269_() < 1.0E-4 && (double)diff.m_122239_() < 1.0E-4 ? Vector3f.f_122223_.m_122281_() : Vector3f.f_122225_.m_122281_();
        perp.m_122279_(diff);
        perp.m_122278_();
        perp.m_122261_(radius);
        RenderHelper.renderRectPrism(builder, stack, packedLightIn, start, end, perp);
    }

    public static void renderRectPrism(VertexConsumer builder, PoseStack stack, int packedLightIn, Vector3f start, Vector3f end, float radius, boolean coverEnds) {
        if (coverEnds) {
            Vector3f ext = end.m_122281_();
            ext.m_122267_(start);
            ext.m_122278_();
            ext.m_122261_(radius);
            end.m_122253_(ext);
            start.m_122267_(ext);
        }
        RenderHelper.renderRectPrism(builder, stack, packedLightIn, start, end, radius);
    }

    static {
        VertexFormat from = DefaultVertexFormat.f_85811_;
        vertexColorIndex = -1;
        ImmutableList elements = from.m_86023_();
        for (int i = 0; i < from.m_86023_().size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            if (element.m_86048_() != VertexFormatElement.Usage.COLOR) continue;
            vertexColorIndex = i;
            break;
        }
    }
}

