/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.entity.AbstractGrenade;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class GrenadeItem
extends ItemCoFH {
    protected final IGrenadeFactory<? extends AbstractGrenade> factory;
    protected int radius = 4;
    protected int cooldown = 20;
    private static final AbstractProjectileDispenseBehavior DISPENSER_BEHAVIOR = new AbstractProjectileDispenseBehavior(){

        protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            GrenadeItem grenadeItem = (GrenadeItem)stackIn.m_41720_();
            AbstractGrenade grenade = grenadeItem.factory.createGrenade(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            ItemStack throwStack = ItemHelper.cloneStack(stackIn, 1);
            throwStack.m_41721_(1);
            grenade.m_37446_(throwStack);
            grenade.setRadius(1 + grenadeItem.radius);
            return grenade;
        }

        protected float m_7101_() {
            return 3.0f;
        }
    };

    public GrenadeItem(IGrenadeFactory<? extends AbstractGrenade> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
        ProxyUtils.registerItemModelProperty(this, new ResourceLocation("thrown"), (stack, world, living, seed) -> stack.m_41773_() > 0 ? 1.0f : 0.0f);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        playerIn.m_36335_().m_41524_((Item)this, this.cooldown);
        if (!worldIn.f_46443_) {
            this.createGrenade(stack, worldIn, playerIn);
        }
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!playerIn.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    protected void createGrenade(ItemStack stack, Level world, Player player) {
        AbstractGrenade grenade = this.factory.createGrenade(world, (LivingEntity)player);
        ItemStack throwStack = ItemHelper.cloneStack(stack, 1);
        throwStack.m_41721_(1);
        grenade.m_37446_(throwStack);
        grenade.setRadius(1 + this.radius);
        grenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 0.5f);
        world.m_7967_((Entity)grenade);
    }

    public static interface IGrenadeFactory<T extends AbstractGrenade> {
        public T createGrenade(Level var1, LivingEntity var2);

        public T createGrenade(Level var1, double var2, double var4, double var6);
    }
}

