/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory.container;

import cofh.core.inventory.container.TileContainer;
import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.util.filter.AbstractItemFilter;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.wrapper.InvWrapperGeneric;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.filter.IFilterableTile;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TileItemFilterContainer
extends TileContainer
implements IFilterOptions {
    protected final IFilterableTile filterable;
    protected AbstractItemFilter filter;
    protected InvWrapperGeneric filterInventory;

    public TileItemFilterContainer(int windowId, Level world, BlockPos pos, Inventory inventory, Player player) {
        super(CoreReferences.TILE_ITEM_FILTER_CONTAINER, windowId, world, pos, inventory, player);
        this.allowSwap = false;
        this.filterable = (IFilterableTile)world.m_7702_(pos);
        this.filter = (AbstractItemFilter)this.filterable.getFilter(0);
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperGeneric(this, this.filter.getItems(), slots);
        int rows = MathHelper.clamp(slots / 3, 1, 3);
        int rowSize = slots / rows;
        int xOffset = 62 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        for (int i = 0; i < this.filter.size(); ++i) {
            this.m_38897_(new SlotFalseCopy(this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    public IFilterableTile getFilterableTile() {
        return this.filterable;
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    @Override
    protected int getMergeableSlotCount() {
        return this.filterInventory.m_6643_();
    }

    @Override
    public boolean m_6875_(Player player) {
        if (!FilterHelper.hasFilter(this.filterable, 0)) {
            return false;
        }
        return super.m_6875_(player);
    }

    @Override
    public void m_6877_(Player playerIn) {
        this.filter.setItems(this.filterInventory.getStacks());
        this.filterable.onFilterChanged(0);
        super.m_6877_(playerIn);
    }

    @Override
    public FriendlyByteBuf getContainerPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleContainerPacket(FriendlyByteBuf buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    @Override
    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerPacket.sendToServer(this);
        return ret;
    }

    @Override
    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerPacket.sendToServer(this);
        return ret;
    }
}

