/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.effect;

import cofh.lib.capability.CapabilityRedstoneFlux;
import cofh.lib.effect.EffectCoFH;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyChargeEffect
extends EffectCoFH {
    private final int amount;

    public EnergyChargeEffect(MobEffectCategory typeIn, int liquidColorIn, int amount) {
        super(typeIn, liquidColorIn);
        this.amount = amount;
    }

    public void m_6742_(LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityLivingBaseIn;
            if (this.amount <= 0) {
                this.drainForgeEnergy(player, this.amount);
                this.drainRedstoneFlux(player, this.amount);
            } else {
                this.chargeForgeEnergy(player, this.amount);
                this.chargeRedstoneFlux(player, this.amount);
            }
        }
    }

    private void chargeForgeEnergy(ServerPlayer player, int chargeAmount) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
    }

    private void chargeRedstoneFlux(ServerPlayer player, int chargeAmount) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
    }

    private void drainForgeEnergy(ServerPlayer player, int drainAmount) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
    }

    private void drainRedstoneFlux(ServerPlayer player, int drainAmount) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
    }
}

