/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.config;

import cofh.lib.config.IBaseConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoreServerConfig
implements IBaseConfig {
    public static boolean enableFishingExhaustion = false;
    public static float amountFishingExhaustion = 0.125f;
    public static boolean enableSaplingGrowthMod = false;
    public static int amountSaplingGrowthMod = 4;
    private ForgeConfigSpec.BooleanValue cfgEnableFishingExhaustion;
    private ForgeConfigSpec.DoubleValue cfgAmountFishingExhaustion;
    private ForgeConfigSpec.BooleanValue cfgEnableSaplingGrowthMod;
    private ForgeConfigSpec.IntValue cfgAmountSaplingGrowthMod;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Gameplay");
        builder.push("Fishing");
        this.cfgEnableFishingExhaustion = builder.comment("If TRUE, Fishing will cause exhaustion.").define("Fishing Exhaustion", enableFishingExhaustion);
        this.cfgAmountFishingExhaustion = builder.comment("This option sets the amount of exhaustion caused by fishing, if enabled.").defineInRange("Fishing Exhaustion Amount", (double)amountFishingExhaustion, 0.0, 10.0);
        builder.pop();
        builder.push("World");
        this.cfgEnableSaplingGrowthMod = builder.comment("If TRUE, Sapling growth will be slowed by a configurable factor.").define("Sapling Growth Reduction", enableSaplingGrowthMod);
        this.cfgAmountSaplingGrowthMod = builder.comment("This option sets the growth factor for saplings - they will only grow 1 in N times.").defineInRange("Sapling Growth Reduction Factor", amountSaplingGrowthMod, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
    }

    @Override
    public void refresh() {
        enableFishingExhaustion = (Boolean)this.cfgEnableFishingExhaustion.get();
        amountFishingExhaustion = ((Double)this.cfgAmountFishingExhaustion.get()).floatValue();
        enableSaplingGrowthMod = (Boolean)this.cfgEnableSaplingGrowthMod.get();
        amountSaplingGrowthMod = (Integer)this.cfgAmountSaplingGrowthMod.get();
    }
}

