/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.listbox.IListBoxElement;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.gui.GuiColor;
import cofh.lib.client.gui.IGuiAccess;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.opengl.GL11;

public class ElementListBox
extends ElementBase {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    protected int _marginTop = 2;
    protected int _marginLeft = 2;
    protected int _marginRight = 2;
    protected int _marginBottom = 2;
    protected final List<IListBoxElement> _elements = new LinkedList<IListBoxElement>();
    protected int _firstIndexDisplayed;
    protected int _selectedIndex;
    protected int scrollHoriz;

    public ElementListBox(IGuiAccess containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height);
    }

    public void add(IListBoxElement element) {
        this._elements.add(element);
    }

    public void add(Collection<? extends IListBoxElement> elements) {
        this._elements.addAll(elements);
    }

    public void remove(IListBoxElement element) {
        int e = this._elements.indexOf(element);
        if (this._elements.remove(element)) {
            if (e < this._firstIndexDisplayed) {
                --this._firstIndexDisplayed;
            }
            if (e < this._selectedIndex) {
                --this._selectedIndex;
            }
        }
    }

    public void removeAt(int index) {
        this.scrollHoriz = 0;
        this._firstIndexDisplayed = 0;
        this._selectedIndex = -1;
        this._elements.remove(index);
    }

    public void removeAll() {
        this._elements.clear();
    }

    public int getInternalWidth() {
        int width = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            width = Math.max(this._elements.get(i).getWidth(), width);
        }
        return width;
    }

    public int getInternalHeight() {
        int height = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            height += this._elements.get(i).getHeight();
        }
        return height;
    }

    public int getContentWidth() {
        return this.width - this._marginLeft - this._marginRight;
    }

    public int getContentHeight() {
        return this.height - this._marginTop - this._marginBottom;
    }

    public int getContentTop() {
        return this.posY() + this._marginTop;
    }

    public int getContentLeft() {
        return this.posX() + this._marginLeft;
    }

    public final int getContentBottom() {
        return this.getContentTop() + this.getContentHeight();
    }

    public final int getContentRight() {
        return this.getContentLeft() + this.getContentWidth();
    }

    public ElementListBox setTextColor(Number textColor, Number selectedTextColor) {
        if (textColor != null) {
            this.textColor = textColor.intValue();
        }
        if (selectedTextColor != null) {
            this.selectedTextColor = selectedTextColor.intValue();
        }
        return this;
    }

    public ElementListBox setSelectionColor(Number selectedLineColor) {
        if (selectedLineColor != null) {
            this.selectedLineColor = selectedLineColor.intValue();
        }
        return this;
    }

    public ElementListBox setBackgroundColor(Number backgroundColor, Number borderColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor.intValue();
        }
        if (borderColor != null) {
            this.borderColor = borderColor.intValue();
        }
        return this;
    }

    @Override
    public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
        this.drawColoredModalRect(poseStack, this.posX() - 1, this.posY() - 1, this.posX() + this.width + 1, this.posY() + this.height + 1, this.borderColor);
        this.drawColoredModalRect(poseStack, this.posX(), this.posY(), this.posX() + this.width, this.posY() + this.height, this.backgroundColor);
    }

    @Override
    public void drawForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        int heightDrawn = 0;
        GL11.glEnable((int)2960);
        RenderHelper.drawStencil(matrixStack, this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-this.scrollHoriz), 0.0, 0.0);
        int e = this._elements.size();
        for (int nextElement = this._firstIndexDisplayed; nextElement < e && heightDrawn <= this.getContentHeight(); heightDrawn += this.drawElement(matrixStack, nextElement, this.getContentLeft(), this.getContentTop() + heightDrawn), ++nextElement) {
        }
        matrixStack.m_85849_();
        GL11.glDisable((int)2960);
    }

    protected int drawElement(PoseStack matrixStack, int elementIndex, int x, int y) {
        IListBoxElement element = this._elements.get(elementIndex);
        if (elementIndex == this._selectedIndex) {
            element.draw(matrixStack, this, x, y, this.selectedLineColor, this.selectedTextColor);
        } else {
            element.draw(matrixStack, this, x, y, this.backgroundColor, this.textColor);
        }
        return element.getHeight();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int elementHeight;
        int heightChecked = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && heightChecked <= this.getContentHeight(); heightChecked += elementHeight, ++i) {
            elementHeight = this._elements.get(i).getHeight();
            if (!((double)(this.getContentTop() + heightChecked) <= mouseY) || !((double)(this.getContentTop() + heightChecked + elementHeight) >= mouseY)) continue;
            this.setSelectedIndex(i);
            this.onElementClicked(this._elements.get(i));
            break;
        }
        return true;
    }

    @Override
    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        if (Screen.m_96637_()) {
            if (movement > 0.0) {
                this.scrollLeft();
            } else if (movement < 0.0) {
                this.scrollRight();
            }
        } else if (movement > 0.0) {
            this.scrollUp();
        } else if (movement < 0.0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int heightDisplayed = 0;
        int elementsDisplayed = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && heightDisplayed + this._elements.get(i).getHeight() <= this.height; ++i) {
            heightDisplayed += this._elements.get(i).getHeight();
            ++elementsDisplayed;
        }
        if (this._firstIndexDisplayed + elementsDisplayed < this._elements.size()) {
            ++this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollLeft() {
        this.scrollHoriz = Math.max(this.scrollHoriz - 15, 0);
        this.onScrollH(this.scrollHoriz);
    }

    public void scrollRight() {
        this.scrollHoriz = Math.min(this.scrollHoriz + 15, this.getLastScrollPositionH());
        this.onScrollH(this.scrollHoriz);
    }

    public int getLastScrollPosition() {
        int heightUsed;
        int position = this._elements.size() - 1;
        if (position < 0) {
            return 0;
        }
        for (heightUsed = 0; position >= 0 && heightUsed < this.height; heightUsed += this._elements.get(position--).getHeight()) {
        }
        if (heightUsed > this.height) {
            ++position;
        }
        return position + 1;
    }

    public int getLastScrollPositionH() {
        return Math.max(this.getInternalWidth() - this.getContentWidth(), 0);
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getIndexOf(Object value) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!this._elements.get(i).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        if (this._selectedIndex == -1 || this._selectedIndex >= this._elements.size()) {
            return null;
        }
        return this._elements.get(this._selectedIndex);
    }

    public void setSelectedIndex(int index) {
        if (index >= -1 && index != this._selectedIndex && index < this._elements.size()) {
            this._selectedIndex = index;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int index) {
        return this._elements.get(index);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    public void scrollToV(int index) {
        if (index >= 0 && index < this._elements.size()) {
            this._firstIndexDisplayed = index;
        }
    }

    public void scrollToH(int index) {
        if (index >= 0 && index <= this.getLastScrollPositionH()) {
            this.scrollHoriz = index;
        }
    }

    protected void onElementClicked(IListBoxElement element) {
    }

    protected void onScrollV(int newStartIndex) {
    }

    protected void onScrollH(int newStartIndex) {
    }

    protected void onSelectionChanged(int newIndex, IListBoxElement newElement) {
    }
}

