/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import java.util.function.Supplier;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeDataManagerServer;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketRequestShapeData {
    private final ItemStack card;
    private final ShapeID id;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.card);
        this.id.toBytes(buf);
    }

    public PacketRequestShapeData(FriendlyByteBuf buf) {
        this.card = buf.m_130267_();
        this.id = new ShapeID(buf);
    }

    public PacketRequestShapeData(ItemStack card, ShapeID id) {
        this.card = card;
        this.id = id;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Shape shape = ShapeCardItem.getShape(this.card);
            boolean solid = ShapeCardItem.isSolid(this.card);
            BlockPos dimension = ShapeCardItem.getDimension(this.card);
            BlockPos clamped = new BlockPos(Math.min(dimension.m_123341_(), 512), Math.min(dimension.m_123342_(), 256), Math.min(dimension.m_123343_(), 512));
            int dy = clamped.m_123342_();
            ItemStack copy = this.card.m_41777_();
            IFormula formula = shape.getFormulaFactory().get();
            formula = formula.correctFormula(solid);
            formula.setup((Level)ctx.getSender().m_183503_(), new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), copy.m_41783_());
            for (int y = 0; y < dy; ++y) {
                ShapeDataManagerServer.pushWork(this.id, copy, y, formula, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }
}

