/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketGrabbedEntitiesToClient {
    private final BlockPos pos;
    private final Set<Integer> grabbedEntities;

    public PacketGrabbedEntitiesToClient(BlockPos pos, Set<Integer> grabbedEntities) {
        this.pos = pos;
        this.grabbedEntities = new HashSet<Integer>(grabbedEntities);
    }

    public PacketGrabbedEntitiesToClient(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.grabbedEntities = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.grabbedEntities.add(buf.readInt());
        }
        this.pos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.grabbedEntities.size());
        for (Integer entity : this.grabbedEntities) {
            buf.writeInt(entity.intValue());
        }
        buf.m_130064_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity patt1428$temp = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (patt1428$temp instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)patt1428$temp;
                mover.getLogic().setGrabbedEntitiesClient(this.grabbedEntities);
            }
        });
        ctx.setPacketHandled(true);
    }
}

