/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.client.DelayedRenderer;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.VehicleBuilderTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.MoverRenderer;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import mcjty.rftoolsbuilder.modules.mover.logic.EntityMovementLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class MoverTileEntity
extends TickingTileEntity {
    public static final int SLOT_VEHICLE_CARD = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific((Item[])new Item[]{(Item)MoverModule.VEHICLE_CARD.get()}).in().out(), 0, 154, 11).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).onUpdate((slot, stack) -> this.updateVehicle()).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Mover").containerSupplier(DefaultContainerProvider.container(MoverModule.CONTAINER_MOVER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @GuiValue
    private String name;
    @GuiValue
    public static final Value<?, String> VALUE_CONNECTIONS = Value.create((String)"connections", (Type)Type.STRING, MoverTileEntity::getConnectionCount, MoverTileEntity::setConnectionCount);
    private String connections = "";
    public static final Set<Integer> wantUnmount = new HashSet<Integer>();
    private int cnt;
    private Set<BlockPos> invisibleMoverBlocks = null;
    private final EntityMovementLogic logic = new EntityMovementLogic(this);
    private final Map<Direction, BlockPos> network = new EnumMap<Direction, BlockPos>(Direction.class);
    private float prevPartialTicks = Float.NaN;
    private float dpartial = 0.0f;

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MoverTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public MoverTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.TYPE_MOVER.get(), pos, state);
    }

    public Map<Direction, BlockPos> getNetwork() {
        return this.network;
    }

    public EntityMovementLogic getLogic() {
        return this.logic;
    }

    public String getName() {
        return this.name;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invisibleMoverBlocks != null) {
            this.removeInvisibleBlocks();
        }
    }

    protected void tickServer() {
        this.updateVehicleStatus();
        this.logic.tryMoveVehicleServer();
    }

    protected void tickClient() {
        this.handleRender();
    }

    private void handleRender() {
        ItemStack vehicle = this.getCard();
        if (VehicleBuilderTileEntity.isVehicleCard(vehicle)) {
            MoverRenderer.addPreRender(this.f_58858_, () -> {
                float partialTicks = MoverRenderer.getPartialTicks();
                this.logic.tryMoveVehicleClientEntities(partialTicks);
            }, this::isMoverThere);
            DelayedRenderer.addRender((BlockPos)this.f_58858_, (poseStack, cameraVec) -> {
                float partialTicks = MoverRenderer.getPartialTicks();
                Vec3 offset = this.logic.tryMoveVehicleThisPlayer(partialTicks);
                MoverRenderer.actualRender(this, poseStack, cameraVec, vehicle, partialTicks, offset);
            }, this::isMoverThere);
        }
    }

    @NotNull
    private Boolean isMoverThere(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MoverTileEntity) {
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            return !mover.getCard().m_41619_();
        }
        return false;
    }

    public boolean isMoving() {
        if (this.getCard().m_41619_()) {
            return false;
        }
        return this.logic.getDestination() != null;
    }

    private void updateVehicleStatus() {
        if (this.logic.getDestination() != null) {
            if (this.invisibleMoverBlocks != null) {
                BlockState invisibleState = ((Block)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
                this.invisibleMoverBlocks.forEach(p -> {
                    if (this.f_58857_.m_8055_(p) == invisibleState) {
                        this.f_58857_.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                    }
                });
                this.invisibleMoverBlocks = null;
            }
        } else {
            if (this.invisibleMoverBlocks == null) {
                this.updateVehicle();
                this.cnt = 0;
            }
            --this.cnt;
            if (this.cnt <= 0) {
                this.cnt = 4;
                BlockState invisibleState = ((Block)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
                this.invisibleMoverBlocks.forEach(p -> {
                    if (this.f_58857_.m_8055_(p) != invisibleState && this.f_58857_.m_8055_(p).m_60767_().m_76336_()) {
                        this.f_58857_.m_7731_(p, invisibleState, 3);
                    }
                });
            }
        }
    }

    private void updateVehicle() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (this.invisibleMoverBlocks == null) {
            this.invisibleMoverBlocks = new HashSet<BlockPos>();
        }
        this.cnt = 0;
        this.removeInvisibleBlocks();
        if (!vehicle.m_41619_()) {
            Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(vehicle, this.f_58858_.m_142082_(1, 1, 1));
            blocks.values().forEach(this.invisibleMoverBlocks::addAll);
        } else {
            this.logic.setDestination(null);
        }
        this.markDirtyClient();
    }

    private void removeInvisibleBlocks() {
        BlockState invisibleState = ((Block)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
        this.invisibleMoverBlocks.forEach(p -> {
            if (this.f_58857_.m_8055_(p) == invisibleState) {
                this.f_58857_.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            }
        });
        this.invisibleMoverBlocks.clear();
    }

    public void arriveAtDestination() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.logic.getDestination());
        if (blockEntity instanceof MoverTileEntity) {
            MoverTileEntity destMover = (MoverTileEntity)blockEntity;
            destMover.items.setStackInSlot(0, this.getCard());
            this.items.setStackInSlot(0, ItemStack.f_41583_);
            destMover.setSource(null);
            destMover.updateVehicle();
            destMover.updateVehicleStatus();
        }
        this.logic.setDestination(null);
        this.cnt = 0;
        this.updateVehicle();
        this.updateVehicleStatus();
        this.markDirtyClient();
    }

    public void setSource(BlockPos pos) {
        this.logic.setSource(pos);
        this.m_6596_();
    }

    public boolean isAvailable() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (!vehicle.m_41619_()) {
            return false;
        }
        if (this.logic.getDestination() != null) {
            return false;
        }
        return this.logic.getSource() == null;
    }

    public String getConnectionCount() {
        return this.connections;
    }

    public void setConnectionCount(String v) {
        this.connections = v;
    }

    public ItemStack getCard() {
        return this.items.getStackInSlot(0);
    }

    private void addConnection(Direction direction, BlockPos pos) {
        this.network.put(direction, pos);
        this.connections = this.connections + direction.name().toUpperCase().charAt(0);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!tagCompound.m_128441_(direction.name())) continue;
            this.addConnection(direction, NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_(direction.name())));
        }
        this.logic.load(tagCompound);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.name = info.m_128461_("name");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!this.network.containsKey(direction)) continue;
            tagCompound.m_128365_(direction.name(), (Tag)NbtUtils.m_129224_((BlockPos)this.network.get(direction)));
        }
        this.logic.save(tagCompound);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.name != null) {
            info.m_128359_("name", this.name);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.loadClientDataFromNBT(tag);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        ItemStack card = this.items.getStackInSlot(0);
        CompoundTag tag = new CompoundTag();
        card.m_41739_(tag);
        tagCompound.m_128365_("card", (Tag)tag);
        this.logic.saveClientDataToNBT(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag tag = tagCompound.m_128469_("card");
        this.items.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)tag));
        this.logic.loadClientDataFromNBT(tagCompound);
    }
}

