/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public interface ILinkable
extends IControllerBoundable {
    default public void linkToController(BlockPos controllerPos) {
        if (!this.canBeLinked() || this.isLinked()) {
            return;
        }
        Level level = this.getStorageBlockLevel();
        if (!level.m_5776_() && WorldHelper.getLoadedBlockEntity(level, controllerPos, ControllerBlockEntityBase.class).isPresent()) {
            boolean hadControllerPos = this.getControllerPos().isPresent();
            if (!hadControllerPos) {
                this.setControllerPos(controllerPos);
            }
            this.runOnController(level, controller -> {
                if (!controller.addLinkedBlock(this.getStorageBlockPos()) && !hadControllerPos) {
                    this.removeControllerPos();
                }
            });
        }
    }

    default public void unlinkFromController() {
        Level level = this.getStorageBlockLevel();
        if (!level.m_5776_()) {
            this.runOnController(level, controller -> controller.removeLinkedBlock(this.getStorageBlockPos()));
            this.removeControllerPos();
            this.setNotLinked();
        }
    }

    default public void setNotLinked() {
    }

    public Set<BlockPos> getConnectablePositions();

    public boolean connectLinkedSelf();

    @Override
    public void setControllerPos(BlockPos var1);

    @Override
    public Optional<BlockPos> getControllerPos();

    public boolean isLinked();

    default public boolean canBeLinked() {
        return true;
    }
}

