/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.theillusivec4.comforts.common.block.ComfortsBaseBlock;
import top.theillusivec4.comforts.common.block.RopeAndNailBlock;
import top.theillusivec4.comforts.common.tileentity.HammockTileEntity;

public class HammockBlock
extends ComfortsBaseBlock {
    private static final VoxelShape HAMMOCK_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(ComfortsBaseBlock.BedType.HAMMOCK, color, BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60918_(SoundType.f_56745_).m_60978_(0.1f));
        this.color = color;
        this.setRegistryName("comforts", "hammock_" + color.m_41065_());
    }

    public static Direction getDirectionToOther(BedPart part, Direction facing) {
        return part == BedPart.FOOT ? facing : facing.m_122424_();
    }

    public static void dropRopeSupport(BlockPos pos, Direction direction, boolean isHead, Level worldIn) {
        BlockPos ropePos = isHead ? pos.m_142300_(direction) : pos.m_142300_(direction.m_122424_());
        BlockState ropeState = worldIn.m_8055_(ropePos);
        if (ropeState.m_60734_() instanceof RopeAndNailBlock) {
            worldIn.m_46597_(ropePos, (BlockState)ropeState.m_61124_((Property)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = HammockBlock.m_49557_((BlockState)state).m_122424_();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return HAMMOCK_SHAPE;
    }

    @Override
    public void m_5707_(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        super.m_5707_(worldIn, pos, state, player);
        BedPart bedpart = (BedPart)state.m_61143_((Property)f_49440_);
        boolean isHead = bedpart == BedPart.HEAD;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos otherPos = pos.m_142300_(HammockBlock.getDirectionToOther(bedpart, direction));
        HammockBlock.dropRopeSupport(pos, direction, isHead, worldIn);
        HammockBlock.dropRopeSupport(otherPos, direction, !isHead, worldIn);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return null;
        }
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_142300_(direction);
        FluidState ifluidstate = context.m_43725_().m_6425_(blockpos);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)ComfortsBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_)) : null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HammockTileEntity(pos, state, this.color);
    }
}

